/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.monolith;

import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.monolith.MonolithBlock;
import com.example.junctionmod.monolith.MonolithManager;
import com.example.junctionmod.monolith.MonolithMenu;
import com.example.junctionmod.monolith.MonolithSyncPacket;
import com.example.junctionmod.vorial.VorialNetwork;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonolithBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int TICKS_PER_FUEL = 72000;
    public static final int PROTECTION_RADIUS = 32;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MonolithBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() == ModRegistry.ATERCENITE_DUST.get();
        }
    };
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private int fuelTicks = 0;
    private int maxFuelTicks = 0;
    private final Set<String> whitelist = new HashSet<String>();
    private UUID ownerUUID;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MonolithBlockEntity.this.fuelTicks;
                case 1 -> MonolithBlockEntity.this.maxFuelTicks;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MonolithBlockEntity.this.fuelTicks = value;
                    break;
                }
                case 1: {
                    MonolithBlockEntity.this.maxFuelTicks = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public MonolithBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.MONOLITH_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MonolithBlockEntity be) {
        ItemStack fuel;
        boolean isActive = be.fuelTicks > 0;
        boolean wasActive = (Boolean)state.m_61143_((Property)MonolithBlock.ACTIVE);
        boolean dirty = false;
        if (isActive) {
            --be.fuelTicks;
        }
        if (be.fuelTicks <= 0 && !(fuel = be.itemHandler.getStackInSlot(0)).m_41619_() && fuel.m_41720_() == ModRegistry.ATERCENITE_DUST.get()) {
            fuel.m_41774_(1);
            be.fuelTicks = 72000;
            be.maxFuelTicks = 72000;
            isActive = true;
            dirty = true;
        }
        if (isActive != wasActive) {
            be.m_6596_();
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MonolithBlock.ACTIVE, (Comparable)Boolean.valueOf(isActive)), 3);
            BlockEntity currentBE = level.m_7702_(pos);
            if (currentBE instanceof MonolithBlockEntity) {
                MonolithBlockEntity monolith = (MonolithBlockEntity)currentBE;
                if (isActive) {
                    MonolithManager.addMonolith(level, pos, monolith);
                } else {
                    MonolithManager.removeMonolith(level, pos);
                }
            }
        }
        if (isActive && level.m_46467_() % 100L == 0L) {
            MonolithManager.addMonolith(level, pos, be);
        }
        if (dirty) {
            be.m_6596_();
        }
    }

    public void setOwner(UUID owner) {
        this.ownerUUID = owner;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isOwner(Player player) {
        return this.ownerUUID != null && this.ownerUUID.equals(player.m_20148_());
    }

    public boolean isAllowed(Player player) {
        if (this.isOwner(player)) {
            return true;
        }
        return this.whitelist.contains(player.m_36316_().getName());
    }

    public void setClientWhitelist(List<String> list) {
        this.whitelist.clear();
        this.whitelist.addAll(list);
    }

    public void syncWhitelistToClients() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            VorialNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MonolithSyncPacket(this.f_58858_, new ArrayList<String>(this.whitelist)));
        }
    }

    public void addToWhitelist(String name) {
        this.whitelist.add(name);
        this.m_6596_();
        this.syncWhitelistToClients();
    }

    public void removeFromWhitelist(String name) {
        this.whitelist.remove(name);
        this.m_6596_();
        this.syncWhitelistToClients();
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public ContainerData getData() {
        return this.data;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == null && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("Fuel", this.fuelTicks);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        ListTag whitelistTag = new ListTag();
        for (String name : this.whitelist) {
            whitelistTag.add((Object)StringTag.m_129297_((String)name));
        }
        tag.m_128365_("Whitelist", (Tag)whitelistTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.fuelTicks = tag.m_128451_("Fuel");
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        this.whitelist.clear();
        ListTag list = tag.m_128437_("Whitelist", 8);
        for (Tag t : list) {
            this.whitelist.add(t.m_7916_());
        }
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"\u041c\u043e\u043d\u043e\u043b\u0438\u0442 \u0417\u0430\u0449\u0438\u0442\u044b");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        if (!player.m_9236_().f_46443_) {
            this.syncWhitelistToClients();
        }
        return new MonolithMenu(id, inv, this, this.data);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && ((Boolean)this.m_58900_().m_61143_((Property)MonolithBlock.ACTIVE)).booleanValue()) {
            MonolithManager.addMonolith(this.f_58857_, this.f_58858_, this);
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

