/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.monolith;

import com.example.junctionmod.monolith.MonolithBlockEntity;
import com.example.junctionmod.monolith.MonolithManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="junctionmod")
public class MonolithEvents {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.player.m_9236_().f_46443_) {
            return;
        }
        if (event.player.f_19797_ % 20 != 0) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        MonolithBlockEntity monolith = MonolithManager.getProtectingMonolith(player.m_9236_(), player.m_20183_());
        if (monolith != null && !monolith.isAllowed((Player)player) && !player.m_7500_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 3, false, false));
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        MonolithBlockEntity monolith;
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_7500_() && (monolith = MonolithManager.getProtectingMonolith(player.m_9236_(), event.getPos())) != null && !monolith.isAllowed((Player)player)) {
            CompoundTag data = player.getPersistentData();
            long lastPlaceTime = data.m_128454_("MonolithPlaceCooldown");
            long now = System.currentTimeMillis();
            if (now - lastPlaceTime < 60000L) {
                event.setCanceled(true);
                long secondsLeft = (60000L - (now - lastPlaceTime)) / 1000L;
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7c\u042d\u0444\u0438\u0440 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u044f\u0437\u043e\u043a! \u0416\u0434\u0438\u0442\u0435 " + secondsLeft + "\u0441.")), true);
            } else {
                data.m_128356_("MonolithPlaceCooldown", now);
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7e\u0412\u0430\u0448\u0438 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u0441\u043a\u043e\u0432\u0430\u043d\u044b... (\u041a\u0443\u043b\u0434\u0430\u0443\u043d 60\u0441)"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
        MonolithBlockEntity monolith;
        ServerPlayer player;
        Player player2;
        if (!event.getLevel().f_46443_ && (player2 = event.getEntity()) instanceof ServerPlayer && !(player = (ServerPlayer)player2).m_7500_() && (monolith = MonolithManager.getProtectingMonolith(event.getLevel(), event.getPos())) != null && !monolith.isAllowed((Player)player)) {
            event.setUseBlock(Event.Result.DENY);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u041c\u043e\u043d\u043e\u043b\u0438\u0442\u043e\u043c."), true);
            event.setCanceled(true);
        }
    }
}

