/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.tertserskill;

import com.example.junctionmod.effect.ModMobEffects;
import com.example.junctionmod.tertserskill.LevelUpPacket;
import com.example.junctionmod.tertserskill.TertserSkill;
import com.example.junctionmod.vorial.VorialNetwork;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class TertserProfileScreen
extends Screen {
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("textures/gui/icons.png");
    private final Player player;
    private float animJumps = 0.0f;
    private float animTotal = 0.0f;
    private float animAnomaly = 0.0f;
    private float animLevel = 0.0f;
    private int targetJumps = 0;
    private int targetReq = 10;
    private float targetAnomaly = 0.0f;
    private int targetTotal = 0;
    private int targetAnomalies = 0;
    private int targetLevel = 0;
    private boolean isMarked = false;
    private String cacheRankText = "";
    private String cacheProgressText = "";
    private String cacheAnomalyText = "";
    private String cacheLevelDesc = "";
    private String cacheRiftQuote = "";
    private int cacheQuoteColor = 0xAAAAAA;
    private Button levelUpButton;

    public TertserProfileScreen(Player player) {
        super((Component)Component.m_237113_((String)"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u0422\u0435\u0440\u0446\u0435\u0440\u0430"));
        this.player = player;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.fetchFromCapability();
        this.animJumps = this.targetJumps;
        this.animTotal = this.targetTotal;
        this.animAnomaly = this.targetAnomaly;
        this.animLevel = this.targetLevel;
        this.updateCache();
        int centerX = this.f_96543_ / 2;
        int panelH = 240;
        int panelY = (this.f_96544_ - panelH) / 2;
        int barY_XP = panelY + 75;
        this.levelUpButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2726 \u0412\u041e\u0417\u0412\u042b\u0421\u0418\u0422\u042c\u0421\u042f \u2726"), btn -> {
            VorialNetwork.CHANNEL.sendToServer((Object)new LevelUpPacket());
            this.m_7379_();
        }).m_252987_(centerX - 60, barY_XP - 5, 120, 20).m_253136_());
        this.levelUpButton.f_93624_ = false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        boolean readyToLevelUp;
        super.m_86600_();
        this.fetchFromCapability();
        float speed = 0.15f;
        this.animJumps = Mth.m_14179_((float)speed, (float)this.animJumps, (float)this.targetJumps);
        this.animTotal = Mth.m_14179_((float)speed, (float)this.animTotal, (float)this.targetTotal);
        this.animAnomaly = Mth.m_14179_((float)speed, (float)this.animAnomaly, (float)this.targetAnomaly);
        this.animLevel = Mth.m_14179_((float)speed, (float)this.animLevel, (float)this.targetLevel);
        this.levelUpButton.f_93624_ = readyToLevelUp = this.targetJumps >= this.targetReq && this.targetLevel < 10;
        this.levelUpButton.f_93623_ = readyToLevelUp;
        this.updateCache();
    }

    private void updateCache() {
        int lvl = Math.round(this.animLevel);
        this.cacheRankText = "\u0420\u0430\u043d\u0433 #" + lvl + " - " + this.getRankName(lvl);
        this.cacheProgressText = String.format("\u041e\u043f\u044b\u0442: %d / %d", Math.round(this.animJumps), this.targetReq);
        int percent = (int)(this.animAnomaly * 100.0f);
        this.cacheAnomalyText = "\u0428\u0430\u043d\u0441 \u0430\u043d\u043e\u043c\u0430\u043b\u0438\u0438: " + percent + "%";
        if (this.isMarked) {
            this.cacheAnomalyText = this.cacheAnomalyText + " [\u041a\u041b\u0415\u0419\u041c\u041e]";
        }
        this.cacheLevelDesc = this.getLevelDescription(lvl);
        this.updateQuote(lvl);
    }

    private void updateQuote(int lvl) {
        if (lvl < 5) {
            this.cacheRiftQuote = "\u00a77\"\u041c\u0438\u0440 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043f\u0440\u043e\u0447\u0435\u043d \u0434\u043b\u044f \u0442\u0432\u043e\u0438\u0445 \u0448\u0430\u0433\u043e\u0432...\"";
            this.cacheQuoteColor = 0x888888;
        } else if (lvl < 7) {
            this.cacheRiftQuote = "\u00a7e\"\u0422\u043a\u0430\u043d\u044c \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0442\u044f\u0433\u0438\u0432\u0430\u0435\u0442\u0441\u044f... \u0441\u043b\u044b\u0448\u0438\u0448\u044c \u0442\u0440\u0435\u0441\u043a?\"";
            this.cacheQuoteColor = 0xFFFF55;
        } else if (lvl < 9) {
            this.cacheRiftQuote = "\u00a76\"\u041e\u0441\u0442\u043e\u0440\u043e\u0436\u043d\u0435\u0435. \u0422\u0432\u043e\u044f \u0442\u0435\u043d\u044c \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0448\u0440\u0430\u043c\u044b \u0432 \u043f\u0443\u0441\u0442\u043e\u0442\u0435.\"";
            this.cacheQuoteColor = 0xFFAA00;
        } else {
            this.cacheRiftQuote = "\u00a75\u00a7o\"\u0422\u044b \u2014 \u0445\u043e\u0434\u044f\u0447\u0430\u044f \u043a\u0430\u0442\u0430\u0441\u0442\u0440\u043e\u0444\u0430. \u041c\u0438\u0440\u044b \u0442\u0440\u0435\u0449\u0430\u0442 \u043f\u043e \u0448\u0432\u0430\u043c.\"";
            this.cacheQuoteColor = 0xFF55FF;
        }
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        int anomColor;
        this.m_280273_(gfx);
        int centerX = this.f_96543_ / 2;
        int panelW = 320;
        int panelH = 240;
        int panelX = centerX - panelW / 2;
        int panelY = (this.f_96544_ - panelH) / 2;
        gfx.m_280509_(panelX, panelY, panelX + panelW, panelY + panelH, -587202560);
        gfx.m_280637_(panelX - 1, panelY - 1, panelW + 2, panelH + 2, -12303292);
        gfx.m_280637_(panelX + 4, panelY + 4, panelW - 8, panelH - 8, -14540254);
        Font font = this.f_96547_;
        String nameText = "\u2726 " + this.player.m_7755_().getString() + " \u2726";
        int nameW = font.m_92895_(nameText);
        int nameY = panelY + 20;
        int boxPad = 6;
        gfx.m_280509_(centerX - nameW / 2 - boxPad, nameY - boxPad, centerX + nameW / 2 + boxPad, nameY + 9 + boxPad, -14671840);
        gfx.m_280637_(centerX - nameW / 2 - boxPad, nameY - boxPad, nameW + boxPad * 2, 9 + boxPad * 2, -2838729);
        gfx.m_280137_(font, nameText, centerX, nameY, -10496);
        gfx.m_280137_(font, this.cacheRankText, centerX, nameY + 9 + boxPad + 8, -6250241);
        int barW = 182;
        int barH = 5;
        int barX = centerX - barW / 2;
        int barY_XP = panelY + 75;
        if (this.targetLevel >= 10) {
            gfx.m_280137_(font, "\u00a76\u00a7l\u2726 \u041c\u0410\u041a\u0421\u0418\u041c\u0410\u041b\u042c\u041d\u042b\u0419 \u0423\u0420\u041e\u0412\u0415\u041d\u042c \u2726", centerX, barY_XP - 5, -1);
            String masterJumps = "\u041f\u0440\u044b\u0436\u043a\u043e\u0432 \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \u0410\u0443\u043a\u0442\u043e\u0440: " + (int)this.animJumps;
            gfx.m_280137_(font, masterJumps, centerX, barY_XP + 8, -5592406);
        } else if (this.levelUpButton.f_93624_) {
            float pulse = (float)Math.sin((float)this.player.f_19797_ * 0.1f) * 0.5f + 0.5f;
            int readyColor = Mth.m_14169_((float)0.15f, (float)(0.5f + pulse * 0.5f), (float)1.0f);
            gfx.m_280137_(font, "\u2728 \u0414\u041e\u0421\u0422\u0423\u041f\u041d\u041e \u0412\u041e\u0417\u0412\u042b\u0428\u0415\u041d\u0418\u0415 \u2728", centerX, barY_XP - 18, readyColor);
        } else {
            gfx.m_280218_(ICONS_TEXTURE, barX, barY_XP, 0, 64, barW, barH);
            float xpProgress = this.animJumps / (float)Math.max(1, this.targetReq);
            int xpFill = (int)((float)barW * Math.min(xpProgress, 1.0f));
            if (xpFill > 0) {
                gfx.m_280218_(ICONS_TEXTURE, barX, barY_XP, 0, 69, xpFill, barH);
            }
            gfx.m_280137_(font, this.cacheProgressText, centerX, barY_XP - 10, 0xFFFFFF);
        }
        int barY_Anom = panelY + 115;
        gfx.m_280218_(ICONS_TEXTURE, barX, barY_Anom, 0, 64, barW, barH);
        int anomFill = (int)((float)barW * Math.min(this.animAnomaly, 1.0f));
        int n = anomColor = this.isMarked ? -6291296 : this.getRiskColor((int)(this.animAnomaly * 100.0f));
        if (anomFill > 0) {
            gfx.m_280509_(barX, barY_Anom, barX + anomFill, barY_Anom + barH, anomColor);
        }
        gfx.m_280137_(font, this.cacheAnomalyText, centerX, barY_Anom - 10, this.isMarked ? -43521 : anomColor);
        int fatalChance = this.isMarked ? 10 : 1;
        gfx.m_280137_(font, "\u0412\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c \u0433\u0438\u0431\u0435\u043b\u0438: " + fatalChance + "%", centerX, barY_Anom + 10, -8947849);
        int descY = panelY + 150;
        float scale = 1.0f;
        int textWidth = font.m_92895_(this.cacheLevelDesc);
        if (textWidth > panelW - 20) {
            scale = (float)(panelW - 20) / (float)textWidth;
        }
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_252880_((float)centerX, (float)descY, 0.0f);
        gfx.m_280168_().m_85841_(scale, scale, scale);
        gfx.m_280137_(font, this.cacheLevelDesc, 0, 0, -11141121);
        gfx.m_280168_().m_85849_();
        int statsY = panelY + 180;
        String statTotal = "\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u044b\u0436\u043a\u043e\u0432: " + (int)this.animTotal;
        String statBad = "\u0421\u0431\u043e\u0435\u0432: " + this.targetAnomalies;
        gfx.m_280056_(font, statTotal, panelX + 25, statsY, -2236963, false);
        gfx.m_280056_(font, statBad, panelX + panelW - 25 - font.m_92895_(statBad), statsY, -43691, false);
        gfx.m_280137_(font, this.cacheRiftQuote, centerX, panelY + 215, this.cacheQuoteColor);
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
    }

    private void fetchFromCapability() {
        if (this.player == null) {
            return;
        }
        this.isMarked = this.player.m_21023_((MobEffect)ModMobEffects.EXILE_MARK.get());
        this.player.getCapability(TertserSkill.INSTANCE).ifPresent(skill -> {
            this.targetLevel = skill.getCurrentLevel();
            this.targetJumps = skill.getJumpsCount();
            this.targetReq = TertserSkill.getRequirementForLevel(skill.getCurrentLevel());
            double chance = skill.getAnomalyChance();
            if (this.isMarked) {
                chance += 0.25;
            }
            this.targetAnomaly = (float)chance;
            this.targetTotal = skill.getTotalJumpsCount();
            this.targetAnomalies = skill.getAnomaliesCount();
        });
    }

    private void syncDisplayedWithTarget() {
    }

    private int getRiskColor(int percent) {
        if (percent < 10) {
            return -11141291;
        }
        if (percent < 30) {
            return -171;
        }
        return -43691;
    }

    private String getRankName(int level) {
        return switch (level) {
            case 0 -> "\u041d\u0435\u043e\u0444\u0438\u0442";
            case 1 -> "\u041d\u043e\u0432\u0438\u0446\u0438\u0443\u0441";
            case 2 -> "\u0412\u0438\u0430\u0442\u043e\u0440";
            case 3 -> "\u042d\u043a\u0441\u043f\u043b\u043e\u0440\u0430\u0442\u043e\u0440";
            case 4 -> "\u0421\u043f\u0435\u043a\u0443\u043b\u044f\u0442\u043e\u0440";
            case 5 -> "\u0414\u0443\u043a\u0441";
            case 6 -> "\u041f\u0440\u0435\u0444\u0435\u043a\u0442\u0443\u0441";
            case 7 -> "\u0410\u0431\u0438\u0441\u0441\u043e\u043a\u0440\u0430\u0442\u043e\u0440";
            case 8 -> "\u0421\u0442\u0438\u043b\u043e\u043d\u043e\u043c\u043e\u0441";
            case 9 -> "\u041a\u043e\u043d\u0434\u0438\u0442\u043e\u0440";
            case 10 -> "\u0410\u0443\u043a\u0442\u043e\u0440 \u0412\u0438\u0430\u0440\u0443\u043c";
            default -> "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439";
        };
    }

    private String getLevelDescription(int level) {
        return switch (level) {
            case 0 -> "\u041d\u043e\u0432\u0438\u0447\u043e\u043a. \u0421\u0438\u043b\u0430 \u0431\u044c\u0451\u0442 \u0447\u0435\u0440\u0435\u0437 \u043a\u0440\u0430\u0439. \u041a\u0430\u0436\u0434\u044b\u0439 \u043f\u0440\u044b\u0436\u043e\u043a \u2014 \u0440\u0443\u0441\u0441\u043a\u0430\u044f \u0440\u0443\u043b\u0435\u0442\u043a\u0430.";
            case 1 -> "\u041f\u0435\u0440\u0432\u044b\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u0441\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f. \u041f\u0430\u043d\u0438\u043a\u0430 \u0441\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0430\u0446\u0438\u0435\u0439.";
            case 2 -> "\u0427\u0443\u0432\u0441\u0442\u0432\u0443\u0435\u0448\u044c \"\u0432\u043a\u0443\u0441\" \u043c\u0438\u0440\u043e\u0432. \u0428\u0430\u043d\u0441 \u043f\u043e\u043f\u0430\u0441\u0442\u044c \u043d\u0435 \u0442\u0443\u0434\u0430 \u0432\u0441\u0451 \u0435\u0449\u0451 \u043f\u0443\u0433\u0430\u044e\u0449\u0435 \u0432\u044b\u0441\u043e\u043a.";
            case 3 -> "\u0420\u0438\u0442\u043c \u043f\u0440\u044b\u0436\u043a\u0430 \u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0441\u044f \u0437\u043d\u0430\u043a\u043e\u043c\u044b\u043c. \u0411\u0435\u0437\u0434\u043d\u0430 \u043e\u0442\u0441\u0442\u0443\u043f\u0430\u0435\u0442.";
            case 4 -> "\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c \u043f\u043e\u0447\u0442\u0438 \u043f\u043e\u043b\u043d\u044b\u0439. \u0410\u043d\u043e\u043c\u0430\u043b\u0438\u0438 \u2014 \u0434\u043e\u0441\u0430\u0434\u043d\u0430\u044f \u0440\u0435\u0434\u043a\u043e\u0441\u0442\u044c.";
            case 5 -> "\u0422\u044b \u043d\u0435 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0443\u0435\u0448\u044c \u043c\u0435\u0436\u0434\u0443 \u043c\u0438\u0440\u0430\u043c\u0438, \u0442\u044b \u0438\u043c\u0438 \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u0448\u044c.";
            case 6 -> "\u0420\u0435\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u2014 \u043f\u043b\u0430\u0441\u0442\u0438\u043b\u0438\u043d \u0432 \u0442\u0432\u043e\u0438\u0445 \u0440\u0443\u043a\u0430\u0445. \u0428\u0451\u043f\u043e\u0442 \u0411\u0435\u0437\u043c\u043e\u043b\u0432\u043d\u044b\u0445 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0441\u0442\u0440\u0430\u0448\u0435\u043d.";
            case 7 -> "\u041b\u0435\u0433\u0435\u043d\u0434\u044b \u0445\u043e\u0434\u044f\u0442 \u043f\u043e \u043c\u0438\u0440\u0430\u043c \u043e \u0442\u043e\u043c, \u043a\u0442\u043e \u043d\u0435 \u0431\u043e\u0438\u0442\u0441\u044f \u0440\u0430\u0437\u043b\u043e\u043c\u043e\u0432.";
            case 8 -> "\u0422\u044b \u0447\u0443\u0432\u0441\u0442\u0432\u0443\u0435\u0448\u044c \u0438\u0437\u043d\u0430\u043d\u043a\u0443 \u043c\u0438\u0440\u043e\u0437\u0434\u0430\u043d\u0438\u044f. \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0447\u0442\u0438 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.";
            case 9 -> "\u0412\u043e\u043b\u044f \u0441\u0438\u043b\u044c\u043d\u0435\u0435 \u0437\u0430\u043a\u043e\u043d\u0430. \u0422\u044b \u043f\u0438\u0448\u0435\u0448\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u043f\u0440\u044b\u0436\u043a\u0430 \u0441\u0430\u043c.";
            case 10 -> "\u0410\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c. \u0422\u044b \u0441\u0442\u0430\u043b \u0442\u0435\u043c, \u043a\u043e\u0433\u043e \u0431\u043e\u044f\u043b\u0438\u0441\u044c \u0421\u043e\u0437\u0434\u0430\u0442\u0435\u043b\u0438.";
            default -> "";
        };
    }
}

