/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.tertserskill;

import com.example.junctionmod.tertserskill.ITertserSkill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class TertserSkill
implements ITertserSkill {
    public static final Capability<ITertserSkill> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITertserSkill>(){});
    private int currentLevel = 0;
    private int jumpsCount = 0;
    private int totalJumpsCount = 0;
    private int anomaliesCount = 0;
    private final List<JumpRecord> jumpHistory = new ArrayList<JumpRecord>();
    private long madnessEndTime = 0L;
    private final List<Long> anomalyTimestamps = new ArrayList<Long>();
    private final List<GlobalPos> knownAnchors = new ArrayList<GlobalPos>();
    private final Map<GlobalPos, String> anchorNames = new HashMap<GlobalPos, String>();
    private int ownedAnchorsCount = 0;

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public Map<GlobalPos, String> getAnchorNames() {
        return this.anchorNames;
    }

    @Override
    public void copyFrom(ITertserSkill otherSkill) {
        if (!(otherSkill instanceof TertserSkill)) {
            return;
        }
        TertserSkill other = (TertserSkill)otherSkill;
        this.currentLevel = other.currentLevel;
        this.jumpsCount = other.jumpsCount;
        this.totalJumpsCount = other.totalJumpsCount;
        this.anomaliesCount = other.anomaliesCount;
        this.madnessEndTime = other.madnessEndTime;
        this.jumpHistory.clear();
        this.jumpHistory.addAll(other.jumpHistory);
        this.anomalyTimestamps.clear();
        this.anomalyTimestamps.addAll(other.anomalyTimestamps);
        this.knownAnchors.clear();
        this.knownAnchors.addAll(other.knownAnchors);
        this.anchorNames.clear();
        this.anchorNames.putAll(other.anchorNames);
        this.ownedAnchorsCount = other.ownedAnchorsCount;
    }

    public void forgetAnchor(GlobalPos pos) {
        this.knownAnchors.remove(pos);
        this.anchorNames.remove(pos);
    }

    @Override
    public void setCurrentLevel(int level) {
        this.currentLevel = level;
    }

    @Override
    public void initializeIfNeeded() {
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public int getJumpsCount() {
        return this.jumpsCount;
    }

    @Override
    public void setJumpsCount(int count) {
        this.jumpsCount = count;
    }

    @Override
    public int getTotalJumpsCount() {
        return this.totalJumpsCount;
    }

    @Override
    public void setTotalJumpsCount(int count) {
        this.totalJumpsCount = count;
    }

    @Override
    public int getAnomaliesCount() {
        return this.anomaliesCount;
    }

    @Override
    public void setAnomaliesCount(int count) {
        this.anomaliesCount = count;
    }

    @Override
    public void incrementAnomalies() {
        ++this.anomaliesCount;
    }

    @Override
    public boolean incrementJumps() {
        int req = TertserSkill.getRequirementForLevel(this.currentLevel);
        if (this.jumpsCount < req) {
            ++this.jumpsCount;
            ++this.totalJumpsCount;
            return this.jumpsCount >= req;
        }
        ++this.totalJumpsCount;
        return false;
    }

    @Override
    public void manualLevelUp() {
        int req = TertserSkill.getRequirementForLevel(this.currentLevel);
        if (this.jumpsCount >= req && this.currentLevel < 10) {
            this.jumpsCount = 0;
            ++this.currentLevel;
        }
    }

    @Override
    public double getAnomalyChance() {
        double chance = 0.45 - (double)this.currentLevel * 0.04;
        return Math.max(0.05, chance);
    }

    public static int getRequirementForLevel(int level) {
        return 10 + level * 5;
    }

    public static int getMaxVorialForLevel(int level) {
        return 200 + level * 50;
    }

    @Override
    public void recordJump(String dimensionId) {
        this.jumpHistory.add(new JumpRecord(System.currentTimeMillis(), dimensionId));
        this.cleanHistory();
    }

    @Override
    public List<String> getRecentDimensions(int minutes) {
        long threshold = System.currentTimeMillis() - (long)(minutes * 60) * 1000L;
        return this.jumpHistory.stream().filter(r -> r.time >= threshold).map(JumpRecord::dimension).collect(Collectors.toList());
    }

    @Override
    public int getJumpsInLast(int minutes) {
        long threshold = System.currentTimeMillis() - (long)(minutes * 60) * 1000L;
        return (int)this.jumpHistory.stream().filter(r -> r.time >= threshold).count();
    }

    @Override
    public void setMadnessEndTime(long timestamp) {
        this.madnessEndTime = timestamp;
    }

    @Override
    public long getMadnessEndTime() {
        return this.madnessEndTime;
    }

    @Override
    public boolean isMadnessActive() {
        return System.currentTimeMillis() < this.madnessEndTime;
    }

    @Override
    public boolean recordAnomalyEvent() {
        long now = System.currentTimeMillis();
        this.anomalyTimestamps.add(now);
        long threshold = now - 1800000L;
        this.anomalyTimestamps.removeIf(t -> t < threshold);
        return this.anomalyTimestamps.size() >= 3;
    }

    private void cleanHistory() {
        long threshold = System.currentTimeMillis() - 900000L;
        this.jumpHistory.removeIf(r -> r.time < threshold);
    }

    @Override
    public void discoverAnchor(GlobalPos pos) {
        if (!this.isAnchorKnown(pos)) {
            this.knownAnchors.add(pos);
            this.anchorNames.put(pos, "\u0421\u0438\u0433\u043d\u0430\u043b " + pos.m_122646_().m_123344_());
        }
    }

    @Override
    public void discoverAnchor(GlobalPos pos, String name) {
        if (!this.isAnchorKnown(pos)) {
            this.knownAnchors.add(pos);
        }
        this.anchorNames.put(pos, name);
    }

    @Override
    public boolean isAnchorKnown(GlobalPos pos) {
        return this.knownAnchors.contains(pos);
    }

    @Override
    public List<GlobalPos> getKnownAnchors() {
        return new ArrayList<GlobalPos>(this.knownAnchors);
    }

    @Override
    public int getOwnedAnchorsCount() {
        return this.ownedAnchorsCount;
    }

    @Override
    public void changeOwnedAnchorsCount(int delta) {
        this.ownedAnchorsCount = Math.max(0, this.ownedAnchorsCount + delta);
    }

    @Override
    public void setClientData(int owned, List<GlobalPos> anchors, List<String> names) {
        this.ownedAnchorsCount = owned;
        this.knownAnchors.clear();
        this.knownAnchors.addAll(anchors);
        this.anchorNames.clear();
        for (int i = 0; i < anchors.size(); ++i) {
            String name = i < names.size() ? names.get(i) : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0438\u0433\u043d\u0430\u043b";
            this.anchorNames.put(anchors.get(i), name);
        }
    }

    @Override
    public CompoundTag saveNBTData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("level", this.currentLevel);
        nbt.m_128405_("jumps", this.jumpsCount);
        nbt.m_128405_("total", this.totalJumpsCount);
        nbt.m_128405_("anomalies", this.anomaliesCount);
        nbt.m_128356_("madnessEnd", this.madnessEndTime);
        ListTag jumpList = new ListTag();
        for (JumpRecord jumpRecord : this.jumpHistory) {
            CompoundTag entry = new CompoundTag();
            entry.m_128356_("t", jumpRecord.time);
            entry.m_128359_("d", jumpRecord.dimension);
            jumpList.add((Object)entry);
        }
        nbt.m_128365_("jumpHistory", (Tag)jumpList);
        ListTag anomalyList = new ListTag();
        for (Long time : this.anomalyTimestamps) {
            anomalyList.add((Object)LongTag.m_128882_((long)time));
        }
        nbt.m_128365_("anomalyHistory", (Tag)anomalyList);
        nbt.m_128405_("OwnedAnchors", this.ownedAnchorsCount);
        ListTag listTag = new ListTag();
        for (GlobalPos gp : this.knownAnchors) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Dim", gp.m_122640_().m_135782_().toString());
            tag.m_128405_("X", gp.m_122646_().m_123341_());
            tag.m_128405_("Y", gp.m_122646_().m_123342_());
            tag.m_128405_("Z", gp.m_122646_().m_123343_());
            String name = this.anchorNames.getOrDefault(gp, "\u0421\u0438\u0433\u043d\u0430\u043b " + gp.m_122646_().m_123344_());
            tag.m_128359_("Name", name);
            listTag.add((Object)tag);
        }
        nbt.m_128365_("KnownAnchors", (Tag)listTag);
        return nbt;
    }

    @Override
    public void loadNBTData(CompoundTag nbt) {
        int i;
        ListTag list;
        this.currentLevel = nbt.m_128451_("level");
        this.jumpsCount = nbt.m_128451_("jumps");
        this.totalJumpsCount = nbt.m_128451_("total");
        this.anomaliesCount = nbt.m_128451_("anomalies");
        this.madnessEndTime = nbt.m_128454_("madnessEnd");
        this.jumpHistory.clear();
        if (nbt.m_128441_("jumpHistory")) {
            list = nbt.m_128437_("jumpHistory", 10);
            for (i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                this.jumpHistory.add(new JumpRecord(entry.m_128454_("t"), entry.m_128461_("d")));
            }
        }
        this.anomalyTimestamps.clear();
        if (nbt.m_128441_("anomalyHistory")) {
            list = nbt.m_128437_("anomalyHistory", 4);
            for (i = 0; i < list.size(); ++i) {
                this.anomalyTimestamps.add(((LongTag)list.get(i)).m_7046_());
            }
        }
        this.ownedAnchorsCount = nbt.m_128451_("OwnedAnchors");
        this.knownAnchors.clear();
        this.anchorNames.clear();
        if (nbt.m_128441_("KnownAnchors")) {
            list = nbt.m_128437_("KnownAnchors", 10);
            for (i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                ResourceLocation dimLoc = ResourceLocation.m_135820_((String)tag.m_128461_("Dim"));
                if (dimLoc == null) continue;
                ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimLoc);
                BlockPos pos = new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z"));
                GlobalPos gp = GlobalPos.m_122643_((ResourceKey)dimKey, (BlockPos)pos);
                this.knownAnchors.add(gp);
                if (tag.m_128441_("Name")) {
                    this.anchorNames.put(gp, tag.m_128461_("Name"));
                    continue;
                }
                this.anchorNames.put(gp, "\u0421\u0438\u0433\u043d\u0430\u043b " + pos.m_123344_());
            }
        }
    }

    private record JumpRecord(long time, String dimension) {
    }
}

