/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.vorial;

import com.example.junctionmod.client.ClientPayloadHandler;
import com.example.junctionmod.event.GlobalEventType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class EventSyncPacket {
    private final int eventOrdinal;

    public EventSyncPacket(GlobalEventType type) {
        this.eventOrdinal = type.ordinal();
    }

    public EventSyncPacket(int ordinal) {
        this.eventOrdinal = ordinal;
    }

    public int getEventOrdinal() {
        return this.eventOrdinal;
    }

    public static void encode(EventSyncPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.eventOrdinal);
    }

    public static EventSyncPacket decode(FriendlyByteBuf buf) {
        return new EventSyncPacket(buf.readInt());
    }

    public static void handle(EventSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPayloadHandler.handleEventSync(msg)));
        ctx.get().setPacketHandled(true);
    }
}

