/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.vorial;

import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import com.example.junctionmod.vorial.VorialSyncPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="junctionmod")
public class VorialCommands {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"getvorial").executes(ctx -> VorialCommands.getVorial((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(ctx -> VorialCommands.getVorial((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"target")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setvorial").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> VorialCommands.setVorial((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"), ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> VorialCommands.setVorial((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addvorial").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).executes(ctx -> VorialCommands.addVorial((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"), ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> VorialCommands.addVorial((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"))))));
    }

    private static int getVorial(CommandSourceStack source, ServerPlayer target) {
        target.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
            int current = cap.getVorial();
            int max = VorialCapability.getMaxVorial((Player)target);
            boolean isSuppressed = cap.isSuppressed();
            String suppressionText = isSuppressed ? " \u00a7c(\u041f\u041e\u0414\u0410\u0412\u041b\u0415\u041d\u041e)" : "";
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7bVorial \u0438\u0433\u0440\u043e\u043a\u0430 " + target.m_7755_().getString() + ": \u00a7f" + current + " \u00a77/ " + max + suppressionText)), false);
            VorialCommands.sync(target, cap);
        });
        return 1;
    }

    private static int setVorial(CommandSourceStack source, int value, ServerPlayer target) {
        target.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
            cap.setVorial(value);
            VorialCommands.sync(target, cap);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7a\u0412\u043e\u0440\u0438\u0430\u043b\u044c \u0438\u0433\u0440\u043e\u043a\u0430 " + target.m_7755_().getString() + " \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043d\u0430 " + value)), true);
        });
        return 1;
    }

    private static int addVorial(CommandSourceStack source, int value, ServerPlayer target) {
        target.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
            cap.addVorial((Player)target, value);
            VorialCommands.sync(target, cap);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7a\u0418\u0437\u043c\u0435\u043d\u0435\u043d \u0431\u0430\u043b\u0430\u043d\u0441 (" + (value > 0 ? "+" : "") + value + ") \u0434\u043b\u044f " + target.m_7755_().getString() + ". \u0422\u0435\u043a\u0443\u0449\u0435\u0435: " + cap.getVorial())), true);
        });
        return 1;
    }

    private static void sync(ServerPlayer player, VorialCapability cap) {
        VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
    }
}

