/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.vorial;

import com.example.junctionmod.effect.ModMobEffects;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import com.example.junctionmod.vorial.VorialProvider;
import com.example.junctionmod.vorial.VorialSyncPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="junctionmod")
public class VorialEvents {
    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        VorialCapability.INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<VorialCapability>(){});
        event.register(VorialCapability.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)"junctionmod:vorial_cap");
            if (rl == null) {
                rl = ResourceLocation.fromNamespaceAndPath((String)"junctionmod", (String)"vorial_cap");
            }
            event.addCapability(rl, (ICapabilityProvider)new VorialProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
                cap.markSynced();
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.END || event.side.isClient() || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        serverPlayer.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
            if (cap.needsSync()) {
                VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
                cap.markSynced();
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(VorialCapability.INSTANCE).ifPresent(oldCap -> event.getEntity().getCapability(VorialCapability.INSTANCE).ifPresent(newCap -> newCap.copyFrom((VorialCapability)oldCap)));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.FRACTURED_SPARK.get(), 24000, 0, false, false, true));
            serverPlayer.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0412\u0430\u0448\u0430 \u0438\u0441\u043a\u0440\u0430 \u0442\u0440\u0435\u0441\u043d\u0443\u043b\u0430 \u043f\u043e\u0434 \u0442\u044f\u0436\u0435\u0441\u0442\u044c\u044e \u0441\u043c\u0435\u0440\u0442\u0438..."), false);
            serverPlayer.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
                cap.markSynced();
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                if (cap.needsSync()) {
                    VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
                    cap.markSynced();
                }
            });
        }
    }
}

