/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api.tooltip;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class TooltipBuilder {
    private final List<Component> lines = new ArrayList<Component>();
    private MutableComponent current = Component.m_237113_((String)"");
    private int indent = 0;

    public static TooltipBuilder create() {
        return new TooltipBuilder();
    }

    public TooltipBuilder newLine() {
        if (this.hasContent()) {
            this.clear();
        } else {
            this.lines.add((Component)Component.m_237113_((String)""));
        }
        return this;
    }

    public TooltipBuilder blankLine() {
        this.lines.add((Component)Component.m_237113_((String)""));
        return this;
    }

    public TooltipBuilder indent() {
        ++this.indent;
        return this;
    }

    public TooltipBuilder unindent() {
        if (this.indent > 0) {
            --this.indent;
        }
        return this;
    }

    public TooltipBuilder key(String key, Object ... args) {
        this.current.m_7220_((Component)Component.m_237110_((String)key, (Object[])args));
        return this;
    }

    public TooltipBuilder key(String key, ChatFormatting color, Object ... args) {
        this.current.m_7220_((Component)Component.m_237110_((String)key, (Object[])args).m_130940_(color));
        return this;
    }

    public TooltipBuilder key(String key, Style style, Object ... args) {
        this.current.m_7220_((Component)Component.m_237110_((String)key, (Object[])args).m_130948_(style));
        return this;
    }

    public TooltipBuilder literal(String text, ChatFormatting ... args) {
        MutableComponent component = Component.m_237113_((String)text);
        for (ChatFormatting x : args) {
            component.m_130940_(x);
        }
        this.current.m_7220_((Component)component);
        return this;
    }

    public TooltipBuilder icon(CustomIcon icon) {
        this.current.m_7220_(icon.component());
        return this;
    }

    public TooltipBuilder wrapKey(String key, int maxWordsPerLine, ChatFormatting style, Object ... args) {
        String text = Component.m_237110_((String)key, (Object[])args).getString();
        String[] words = text.split("\\s+");
        int wordCount = words.length;
        if (wordCount == 0) {
            return this;
        }
        int remainingWords = wordCount;
        int remainingChars = text.length();
        int idx = 0;
        while (idx < wordCount) {
            int linesLeft = (remainingWords + maxWordsPerLine - 1) / maxWordsPerLine;
            int aproxLength = remainingChars / linesLeft;
            StringBuilder builder = new StringBuilder();
            int wordsInLine = 0;
            while (idx < wordCount && wordsInLine < maxWordsPerLine) {
                String word = words[idx];
                int line = builder.length() + (builder.isEmpty() ? 0 : 1) + word.length();
                if (wordsInLine > 0 && line > aproxLength) break;
                if (!builder.isEmpty()) {
                    builder.append(' ');
                }
                builder.append(word);
                ++idx;
                ++wordsInLine;
                --remainingWords;
            }
            remainingChars -= builder.length();
            this.current.m_7220_((Component)Component.m_237113_((String)builder.toString()).m_130940_(style));
            if (idx >= wordCount) continue;
            this.clear();
        }
        return this;
    }

    public TooltipBuilder wrapKey(String key, int maxWords, Object ... a) {
        return this.wrapKey(key, maxWords, ChatFormatting.GRAY, a);
    }

    public TooltipBuilder rainbow(String key, RainbowMode type, long cycleTime, int color1, int color2, Object ... a) {
        String text = Component.m_237110_((String)key, (Object[])a).getString();
        long time = System.currentTimeMillis();
        long period = cycleTime <= 0L ? 1L : cycleTime;
        for (int i = 0; i < text.length(); ++i) {
            this.current.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)(switch (type) {
                case RainbowMode.GRADIENT -> {
                    float t = (float)i / (float)(text.length() - 1);
                    int r1 = color1 >> 16 & 0xFF;
                    int g1 = color1 >> 8 & 0xFF;
                    int b1 = color1 & 0xFF;
                    int r2 = color2 >> 16 & 0xFF;
                    int g2 = color2 >> 8 & 0xFF;
                    int b2 = color2 & 0xFF;
                    int r = r1 + Math.round((float)(r2 - r1) * t);
                    int g = g1 + Math.round((float)(g2 - g1) * t);
                    int b = b1 + Math.round((float)(b2 - b1) * t);
                    yield r << 16 | g << 8 | b;
                }
                case RainbowMode.PULSE -> {
                    float n = 0.5f * (1.0f + (float)Math.sin(Math.PI * 2 * (double)((float)(time % period) / (float)period)));
                    yield TooltipBuilder.lerpColor(color1, color2, n);
                }
                case RainbowMode.BLINK -> {
                    float phase = (float)(time % period) / (float)period;
                    if (Math.abs(Math.sin(Math.PI * 2 * (double)((float)i + phase * 10.0f))) > (double)0.9f) {
                        yield 0xFFFFFF;
                    }
                    yield TooltipBuilder.lerpColor(color1, color2, phase);
                }
                case RainbowMode.FADE -> {
                    float n = ((float)(time % period) / (float)period + (float)i / (float)text.length()) % 1.0f;
                    if (n > 0.5f) {
                        n = 1.0f - n;
                    }
                    yield TooltipBuilder.lerpColor(color1, color2, n * 2.0f);
                }
                case RainbowMode.WAVE -> {
                    float hue = ((float)(time % period) / (float)period + 0.5f * (1.0f + (float)Math.sin(Math.PI * 2 * (double)i / (double)text.length()))) % 1.0f;
                    yield Color.HSBtoRGB(hue, 1.0f, 1.0f);
                }
                case RainbowMode.SWITCH -> time % period < period / 2L ? color1 : color2;
                default -> {
                    float hue = ((float)(time % period) / (float)period + (float)i / (float)text.length()) % 1.0f;
                    yield Color.HSBtoRGB(hue, 1.0f, 1.0f);
                }
            })))));
        }
        return this;
    }

    private boolean hasContent() {
        return !this.current.getString().isEmpty() || !this.current.m_7360_().isEmpty();
    }

    private static int lerpColor(int color1, int color2, float norm) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = r1 + Math.round((float)(r2 - r1) * norm);
        int g = g1 + Math.round((float)(g2 - g1) * norm);
        int b = b1 + Math.round((float)(b2 - b1) * norm);
        return r << 16 | g << 8 | b;
    }

    private void clear() {
        if (this.hasContent()) {
            this.lines.add(this.applyIndent((Component)this.current));
        }
        this.current = Component.m_237113_((String)"");
    }

    private Component applyIndent(Component component) {
        return this.indent > 0 ? Component.m_237113_((String)" ".repeat(this.indent)).m_7220_(component) : component;
    }

    public List<Component> build() {
        this.clear();
        return List.copyOf(this.lines);
    }

    public static enum CustomIcon {
        SHIFT,
        TICK,
        STAR,
        INFO,
        CROSS,
        SKULL,
        BLUE_BALL,
        LOCATION,
        HOURGLASS;


        public Component component() {
            return Component.m_237115_((String)("tooltip.icon.knightlib." + this.name().toLowerCase()));
        }
    }

    public static enum RainbowMode {
        SCROLL,
        GRADIENT,
        WAVE,
        PULSE,
        SWITCH,
        BLINK,
        FADE;

    }

    public static enum GradientDir {
        HORIZONTAL,
        VERTICAL;

    }
}

