/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.blockentity;

import dev.xylonity.knightlib.api.interop.GreatChaliceState;
import dev.xylonity.knightlib.registry.KnightLibBlockEntities;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GreatChaliceBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int charges = 0;
    private int prevCharges = 0;
    private GreatChaliceState state = GreatChaliceState.EMPTY;
    private long tickcount = 0L;

    public GreatChaliceBlockEntity(BlockPos pos, BlockState state) {
        super(KnightLibBlockEntities.GREAT_CHALICE.get(), pos, state);
    }

    public int getCharges() {
        return this.charges;
    }

    public void setCharges(int charges) {
        this.charges = Math.min(charges, 12);
        if (charges == 0) {
            this.setState(GreatChaliceState.EMPTY);
        }
        this.prevCharges = this.charges;
        this.m_6596_();
        this.sync();
    }

    public GreatChaliceState getState() {
        return this.state;
    }

    public boolean isFull() {
        return this.getCharges() == 12;
    }

    public void setState(GreatChaliceState newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        this.m_6596_();
        this.sync();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Charges", this.charges);
        tag.m_128405_("PrevCharges", this.prevCharges);
        tag.m_128359_("State", this.state.m_7912_());
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.charges = tag.m_128451_("Charges");
        this.prevCharges = tag.m_128451_("PrevCharges");
        try {
            this.state = GreatChaliceState.valueOf(tag.m_128461_("State").toUpperCase());
        }
        catch (Exception e) {
            this.state = GreatChaliceState.NORMAL;
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("Charges", this.charges);
        tag.m_128405_("PrevCharges", this.prevCharges);
        tag.m_128359_("State", this.state.m_7912_());
        return tag;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T F) {
        if (!(F instanceof GreatChaliceBlockEntity)) {
            return;
        }
        GreatChaliceBlockEntity chalice = (GreatChaliceBlockEntity)F;
        if (chalice.charges == 12 && chalice.tickcount % 15L == 0L) {
            chalice.spawnSpecialParticles();
        }
        if (chalice.charges == 12 && chalice.tickcount % 5L == 0L) {
            chalice.spawnChaoticParticles();
        }
        if (chalice.tickcount % 5L == 0L) {
            chalice.spawnProgressiveParticles(pos);
        }
        ++chalice.tickcount;
    }

    private void spawnSpecialParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            if (this.getState() == GreatChaliceState.NORMAL) {
                for (int i = 0; i < 2; ++i) {
                    double dx = (new Random().nextDouble() - 0.5) * 0.5;
                    double dy = (new Random().nextDouble() - 0.5) * 0.5;
                    double dz = (new Random().nextDouble() - 0.5) * 0.5;
                    if (i % 3 != 0) continue;
                    sv.m_8767_((ParticleOptions)KnightLibParticles.STARSET.get(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5 * Math.random(), (double)this.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.35);
                }
            }
        }
    }

    private void spawnChaoticParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            if (this.getState() == GreatChaliceState.CHAOTIC) {
                double dz;
                double dy;
                double dx;
                int i;
                for (i = 0; i < 2; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.5;
                    dy = (new Random().nextDouble() - 0.5) * 0.5;
                    dz = (new Random().nextDouble() - 0.5) * 0.5;
                    sv.m_8767_((ParticleOptions)ParticleTypes.f_123785_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5 * Math.random(), (double)this.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.3);
                }
                for (i = 0; i < 2; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.5;
                    dy = (new Random().nextDouble() - 0.5) * 0.5;
                    dz = (new Random().nextDouble() - 0.5) * 0.5;
                    sv.m_8767_((ParticleOptions)ParticleTypes.f_123784_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5 * Math.random(), (double)this.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.25);
                }
            }
        }
    }

    private void spawnProgressiveParticles(BlockPos pos) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (int i = 0; i < this.charges; ++i) {
                if (!(sv.f_46441_.m_188501_() < 0.1f)) continue;
                sv.m_8767_((ParticleOptions)ParticleTypes.f_123806_, (double)pos.m_123341_() + 0.5 + (sv.f_46441_.m_188500_() - 0.5) * 0.9, (double)pos.m_123342_() + (double)this.getCharges() / 12.0 + sv.f_46441_.m_188500_() * 0.5, (double)pos.m_123343_() + 0.5 + (sv.f_46441_.m_188500_() - 0.5) * 0.9, 1, 0.0, 0.1, 0.0, 0.0);
            }
        }
    }

    public void sync() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(this.f_58858_), false).forEach(arg_0 -> GreatChaliceBlockEntity.lambda$sync$0((Packet)pkt, arg_0));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$0(Packet pkt, ServerPlayer p) {
        p.f_8906_.m_9829_(pkt);
    }
}

