/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.satisfy.brewery.core.block.BrewingstationBlock;
import net.satisfy.brewery.core.block.entity.BrewstationBlockEntity;
import net.satisfy.farm_and_charm.client.util.ClientUtil;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BrewingstationRenderer
implements BlockEntityRenderer<BrewstationBlockEntity> {
    public BrewingstationRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(BrewstationBlockEntity entity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (!entity.m_58898_() || !(entity.m_58900_().m_60734_() instanceof BrewingstationBlock)) {
            return;
        }
        List<ItemStack> ingredients = entity.getIngredient();
        if (ingredients.isEmpty()) {
            return;
        }
        matrixStack.m_85836_();
        this.setupInitialTransform(matrixStack, entity);
        Random random = new Random(entity.m_58899_().hashCode());
        float angleOffset = 360.0f / (float)ingredients.size();
        for (int index = 0; index < ingredients.size(); ++index) {
            ItemStack stack = ingredients.get(index);
            matrixStack.m_85836_();
            Vector3f position = this.calculateItemPosition(index, angleOffset, ingredients.size());
            this.applyItemTransform(matrixStack, position, angleOffset * (float)index);
            this.renderItems(matrixStack, bufferSource, entity, stack, random);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    private void setupInitialTransform(PoseStack matrixStack, BrewstationBlockEntity entity) {
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252880_(1.0f, 0.3f, 1.0f);
    }

    private Vector3f calculateItemPosition(int index, float angleOffset, int itemCount) {
        if (itemCount == 1) {
            return new Vector3f(0.0f, 0.3f, 0.0f);
        }
        double angleRad = Math.toRadians(angleOffset * (float)index);
        return new Vector3f((float)(0.125 * Math.cos(angleRad)), 0.3f, (float)(0.125 * Math.sin(angleRad)));
    }

    private void applyItemTransform(PoseStack matrixStack, Vector3f position, float angle) {
        Quaternionf rotation = new Quaternionf().rotateY(angle + 35.0f).rotateX(65.0f);
        matrixStack.m_252880_(position.x, position.y, position.z);
        matrixStack.m_252781_(rotation);
    }

    private void renderItems(PoseStack matrixStack, MultiBufferSource bufferSource, BrewstationBlockEntity entity, ItemStack stack, Random random) {
        for (int i = 0; i <= stack.m_41613_() / 8; ++i) {
            matrixStack.m_85836_();
            Vector3f offset = this.offsetRandomly(random);
            matrixStack.m_252880_(offset.x, offset.y, offset.z);
            ClientUtil.renderItem((ItemStack)stack, (PoseStack)matrixStack, (MultiBufferSource)bufferSource, (BlockEntity)entity);
            matrixStack.m_85849_();
        }
    }

    private Vector3f offsetRandomly(Random random) {
        return new Vector3f((random.nextFloat() - 0.5f) * 2.0f * 0.0625f, (random.nextFloat() - 0.5f) * 2.0f * 0.0625f, (random.nextFloat() - 0.5f) * 2.0f * 0.0625f);
    }
}

