/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.crops;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public interface BigCropCapable {
    public int m_7419_();

    public IntegerProperty m_7959_();

    public BooleanProperty getBigProperty();

    public BooleanProperty getGiantProperty();

    default public void tryTransformToBigCrop(Level level, BlockPos pos, BlockState state, boolean usedCompost) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        IntegerProperty age = this.m_7959_();
        BooleanProperty big = this.getBigProperty();
        BooleanProperty giant = this.getGiantProperty();
        if (!(state.m_61138_((Property)age) && state.m_61138_((Property)big) && state.m_61138_((Property)giant))) {
            return;
        }
        int currentAge = (Integer)state.m_61143_((Property)age);
        boolean isBig = (Boolean)state.m_61143_((Property)big);
        boolean isGiant = (Boolean)state.m_61143_((Property)giant);
        if (currentAge != this.m_7419_()) {
            return;
        }
        boolean hasWater = this.hasWaterSourceNearby(level, pos);
        boolean isRaining = level.m_46758_(pos.m_7494_());
        int lightLevel = level.m_46803_(pos.m_7494_());
        RandomSource random = level.m_213780_();
        if (usedCompost) {
            if (!hasWater) {
                return;
            }
            if (!isBig && random.m_188501_() < 0.144f) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)big, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            } else if (isBig && !isGiant && random.m_188501_() < 0.1f) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)giant, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            }
        } else {
            long seed = pos.m_121878_();
            RandomSource staticRandom = RandomSource.m_216335_((long)seed);
            if (staticRandom.m_188501_() >= 0.25f) {
                return;
            }
            if (!isBig && isRaining && lightLevel > 12 && random.m_188501_() < 0.03f) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)big, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            } else if (!isBig && hasWater && random.m_188501_() < 0.144f) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)big, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            }
        }
    }

    private boolean hasWaterSourceNearby(Level level, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!level.m_6425_(checkPos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-2, 0, -2), (BlockPos)pos.m_7918_(2, 2, 2))) {
            if (!level.m_8055_(checkPos).m_60713_((Block)ObjectRegistry.WATER_SPRINKLER.get())) continue;
            return true;
        }
        return false;
    }

    private void spawnHappyParticles(ServerLevel level, BlockPos pos) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.75;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 8, 0.25, 0.25, 0.25, 0.0);
    }
}

