/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.FeedingTroughBlock;
import net.satisfy.farm_and_charm.core.network.PacketHandler;
import net.satisfy.farm_and_charm.core.network.packet.SyncSaturationPacket;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.TagRegistry;
import net.satisfy.farm_and_charm.core.util.SaturationTracker;
import org.jetbrains.annotations.NotNull;

public class FeedingTroughBlockEntity
extends BlockEntity
implements WorldlyContainer {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private boolean updatingState = false;

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FEEDING_TROUGH_BLOCK_ENTITY.get(), pos, state);
    }

    public int @NotNull [] m_7071_(Direction side) {
        return new int[]{0};
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return stack.m_204117_(TagRegistry.FEEDING_TROUGH_FODDER) && this.m_8020_(slot).m_41613_() < 4;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return ((ItemStack)this.items.get(0)).m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        this.m_6596_();
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack stack = ContainerHelper.m_18966_(this.items, (int)slot);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            this.items.set(slot, (Object)ItemStack.f_41583_);
        } else {
            ItemStack current = (ItemStack)this.items.get(slot);
            if (current.m_41619_()) {
                this.items.set(slot, (Object)stack.m_41777_());
            } else if (ItemStack.m_150942_((ItemStack)current, (ItemStack)stack)) {
                int newCount = Math.min(4, current.m_41613_() + stack.m_41613_());
                current.m_41764_(newCount);
                this.items.set(slot, (Object)current);
            }
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void m_6596_() {
        super.m_6596_();
        if (!this.updatingState) {
            this.updatingState = true;
            this.updateBlockState();
            this.updatingState = false;
        }
    }

    private void updateBlockState() {
        BlockState state;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof FeedingTroughBlock) {
            int newSize = ((ItemStack)this.items.get(0)).m_41613_();
            if ((Integer)state.m_61143_((Property)FeedingTroughBlock.SIZE) != newSize) {
                BlockState newState = (BlockState)state.m_61124_((Property)FeedingTroughBlock.SIZE, (Comparable)Integer.valueOf(newSize));
                this.f_58857_.m_7731_(this.f_58858_, newState, 3);
                this.f_58857_.m_7260_(this.f_58858_, state, newState, 3);
            }
        }
    }

    public void onAnimalFed(Animal animal) {
        if (!(animal instanceof SaturationTracker.SaturatedAnimal)) {
            return;
        }
        SaturationTracker.SaturatedAnimal saturated = (SaturationTracker.SaturatedAnimal)animal;
        SaturationTracker tracker = saturated.farm_and_charm$getSaturationTracker();
        tracker.feedDirectly(animal, animal.f_19797_, 5);
        if (!animal.m_9236_().f_46443_) {
            PacketHandler.sendSaturationSync(new SyncSaturationPacket(animal.m_19879_(), tracker.level(), tracker.foodCounter()), (Entity)animal);
        }
    }
}

