/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.config;

import io.github.fishstiz.minecraftcursor.config.AbstractSettings;
import io.github.fishstiz.minecraftcursor.config.ConfigLoader;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Config
implements Serializable {
    private String _hash;
    private boolean itemSlotEnabled = true;
    private boolean itemGrabbingEnabled = true;
    private boolean creativeTabsEnabled = true;
    private boolean enchantmentsEnabled = true;
    private boolean stonecutterRecipesEnabled = true;
    private boolean bookEditEnabled = true;
    private boolean loomPatternsEnabled = true;
    private boolean advancementTabsEnabled = true;
    private boolean worldIconEnabled = true;
    private boolean serverIconEnabled = true;
    private boolean remapCursorsEnabled = true;
    private boolean deferredLoading = false;
    private boolean inactiveWidgetsEnabled = true;
    private boolean aggressiveCursor = false;
    private boolean virtualMode = false;
    private final List<String> blacklist = new ArrayList<String>();
    private final GlobalSettings global = new GlobalSettings();
    private final Map<String, Settings> settings = new HashMap<String, Settings>();
    transient File file;

    Config() {
    }

    public Settings getOrCreateSettings(Cursor cursor) {
        return this.settings.computeIfAbsent(cursor.getTypeKey(), k -> new Settings());
    }

    @NotNull
    public String getHash() {
        if (this._hash == null) {
            this._hash = Config.generateHash(this.settings);
        }
        return this._hash;
    }

    public void setHash(String hash) {
        this._hash = hash;
    }

    public void save() {
        ConfigLoader.save(Objects.requireNonNull(this.file), this);
    }

    public GlobalSettings getGlobal() {
        return this.global;
    }

    public List<String> getBlacklist() {
        return this.blacklist;
    }

    private Settings validateSettings(String key, Settings settings) {
        Settings old = this.settings.computeIfAbsent(key, k -> new Settings());
        Settings validated = settings.copy();
        if (!old.enabled) {
            validated.enabled = false;
        }
        return validated;
    }

    private Settings filterInactive(@NotNull Cursor cursor, @NotNull Settings settingsToApply) {
        Settings currentSettings = this.settings.computeIfAbsent(cursor.getTypeKey(), k -> new Settings());
        Settings validated = settingsToApply.copy();
        if (this.global.isScaleActive()) {
            validated.setScale(currentSettings.getScale());
        }
        if (this.global.isXHotActive()) {
            validated.setXHot(cursor, currentSettings.getXHot());
        }
        if (this.global.isYHotActive()) {
            validated.setYHot(cursor, currentSettings.getYHot());
        }
        return validated;
    }

    public void replaceActiveSettings(Resource resource, Cursor cursor) {
        this.settings.put(cursor.getTypeKey(), this.filterInactive(cursor, resource.getOrCreateSettings(cursor)));
    }

    public void merge(Resource resources) {
        for (Map.Entry<String, Settings> resourceEntry : resources.getAllSettings().entrySet()) {
            String key = resourceEntry.getKey();
            this.settings.put(key, this.validateSettings(key, resourceEntry.getValue()));
        }
    }

    public boolean isCreativeTabsEnabled() {
        return this.creativeTabsEnabled;
    }

    public void setCreativeTabsEnabled(boolean creativeTabsEnabled) {
        this.creativeTabsEnabled = creativeTabsEnabled;
    }

    public boolean isEnchantmentsEnabled() {
        return this.enchantmentsEnabled;
    }

    public void setEnchantmentsEnabled(boolean enchantmentsEnabled) {
        this.enchantmentsEnabled = enchantmentsEnabled;
    }

    public boolean isStonecutterRecipesEnabled() {
        return this.stonecutterRecipesEnabled;
    }

    public void setStonecutterRecipesEnabled(boolean stonecutterRecipesEnabled) {
        this.stonecutterRecipesEnabled = stonecutterRecipesEnabled;
    }

    public boolean isBookEditEnabled() {
        return this.bookEditEnabled;
    }

    public void setBookEditEnabled(boolean bookEditEnabled) {
        this.bookEditEnabled = bookEditEnabled;
    }

    public boolean isLoomPatternsEnabled() {
        return this.loomPatternsEnabled;
    }

    public void setLoomPatternsEnabled(boolean loomPatternsEnabled) {
        this.loomPatternsEnabled = loomPatternsEnabled;
    }

    public boolean isWorldIconEnabled() {
        return this.worldIconEnabled;
    }

    public void setWorldIconEnabled(boolean worldIconEnabled) {
        this.worldIconEnabled = worldIconEnabled;
    }

    public boolean isItemSlotEnabled() {
        return this.itemSlotEnabled;
    }

    public void setItemSlotEnabled(boolean itemSlotEnabled) {
        this.itemSlotEnabled = itemSlotEnabled;
    }

    public boolean isItemGrabbingEnabled() {
        return this.itemGrabbingEnabled;
    }

    public void setItemGrabbingEnabled(boolean itemGrabbingEnabled) {
        this.itemGrabbingEnabled = itemGrabbingEnabled;
    }

    public boolean isAdvancementTabsEnabled() {
        return this.advancementTabsEnabled;
    }

    public void setAdvancementTabsEnabled(boolean advancementTabsEnabled) {
        this.advancementTabsEnabled = advancementTabsEnabled;
    }

    public boolean isServerIconEnabled() {
        return this.serverIconEnabled;
    }

    public void setServerIconEnabled(boolean serverIconEnabled) {
        this.serverIconEnabled = serverIconEnabled;
    }

    public boolean isRemapCursorsEnabled() {
        return this.remapCursorsEnabled;
    }

    public void setRemapCursorsEnabled(boolean remapCursorsEnabled) {
        this.remapCursorsEnabled = remapCursorsEnabled;
    }

    public boolean isDeferredLoading() {
        return this.deferredLoading;
    }

    public void setDeferredLoading(boolean deferredLoading) {
        this.deferredLoading = deferredLoading;
    }

    public boolean isInactiveWidgetsEnabled() {
        return this.inactiveWidgetsEnabled;
    }

    public void setInactiveWidgetsEnabled(boolean inactiveWidgetsEnabled) {
        this.inactiveWidgetsEnabled = inactiveWidgetsEnabled;
    }

    public boolean isAggressiveCursor() {
        return this.aggressiveCursor;
    }

    public void setAggressiveCursor(boolean aggressiveCursor) {
        this.aggressiveCursor = aggressiveCursor;
    }

    public boolean isVirtualMode() {
        return this.virtualMode;
    }

    public void setVirtualMode(boolean virtualMode) {
        this.virtualMode = virtualMode;
    }

    private static String generateHash(Map<String, Settings> settings) {
        long hash = 0L;
        long prime = 31L;
        for (Map.Entry<String, Settings> entry : settings.entrySet()) {
            String key = entry.getKey();
            Settings value = entry.getValue();
            for (char c : key.toCharArray()) {
                hash = hash * prime + (long)c;
            }
            hash = hash * prime + (long)value.scale;
            hash = hash * prime + (long)value.xhot;
            hash = hash * prime + (long)value.yhot;
            hash = hash * prime + (long)(value.enabled ? 1 : 0);
        }
        return Long.toHexString(hash);
    }

    public static class GlobalSettings
    extends AbstractSettings<GlobalSettings> {
        private boolean scaleActive = false;
        private boolean xhotActive = false;
        private boolean yhotActive = false;

        public void setActiveAll(boolean active) {
            this.setScaleActive(active);
            this.setXHotActive(active);
            this.setYHotActive(active);
        }

        public boolean isScaleActive() {
            return this.scaleActive;
        }

        public void setScaleActive(boolean scaleEnabled) {
            this.scaleActive = scaleEnabled;
        }

        public boolean isXHotActive() {
            return this.xhotActive;
        }

        public void setXHotActive(boolean xhotActive) {
            this.xhotActive = xhotActive;
        }

        public boolean isYHotActive() {
            return this.yhotActive;
        }

        public void setYHotActive(boolean yhotActive) {
            this.yhotActive = yhotActive;
        }

        public void setScale(double scale) {
            this.scale = SettingsUtil.sanitizeScale(scale);
        }

        public void setXHot(double xhot) {
            this.setXHot((int)xhot);
        }

        public void setXHot(int xhot) {
            this.xhot = SettingsUtil.sanitizeGlobalHotspot(xhot);
        }

        @Override
        public int getXHot() {
            return SettingsUtil.sanitizeGlobalHotspot(this.xhot);
        }

        public void setYHot(double yhot) {
            this.setYHot((int)yhot);
        }

        public void setYHot(int yhot) {
            this.yhot = SettingsUtil.sanitizeGlobalHotspot(yhot);
        }

        @Override
        public int getYHot() {
            return SettingsUtil.sanitizeGlobalHotspot(this.yhot);
        }

        @Override
        GlobalSettings copy() {
            GlobalSettings globalSettings = new GlobalSettings();
            globalSettings.scale = this.scale;
            globalSettings.xhot = this.xhot;
            globalSettings.yhot = this.yhot;
            globalSettings.scaleActive = this.scaleActive;
            globalSettings.xhotActive = this.xhotActive;
            globalSettings.yhotActive = this.yhotActive;
            return globalSettings;
        }

        public <T extends AbstractSettings<T>> T apply(T settings) {
            T copied = settings.copy();
            ((AbstractSettings)copied).scale = this.isScaleActive() ? this.getScale() : ((AbstractSettings)copied).getScale();
            ((AbstractSettings)copied).xhot = this.isXHotActive() ? this.getXHot() : ((AbstractSettings)copied).getXHot();
            ((AbstractSettings)copied).yhot = this.isYHotActive() ? this.getYHot() : ((AbstractSettings)copied).getYHot();
            return copied;
        }
    }

    public static class Settings
    extends AbstractSettings<Settings> {
        protected boolean enabled = true;
        protected Boolean animated;

        Settings() {
        }

        public void setScale(double scale) {
            this.scale = SettingsUtil.sanitizeScale(scale);
        }

        public void setXHot(@NotNull Cursor cursor, int xhot) {
            this.xhot = SettingsUtil.sanitizeHotspot(xhot, cursor);
        }

        public void setYHot(@NotNull Cursor cursor, int yhot) {
            this.yhot = SettingsUtil.sanitizeHotspot(yhot, cursor);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Boolean isAnimated() {
            return this.animated;
        }

        public void setAnimated(boolean animated) {
            this.animated = animated;
        }

        @Override
        public Settings copy() {
            Settings settings = new Settings();
            settings.scale = this.scale;
            settings.xhot = this.xhot;
            settings.yhot = this.yhot;
            settings.enabled = this.enabled;
            settings.animated = this.animated;
            return settings;
        }
    }

    public static class Resource
    implements Serializable {
        private final Map<String, Settings> settings = new HashMap<String, Settings>();

        public Settings getOrCreateSettings(Cursor cursor) {
            return this.settings.computeIfAbsent(cursor.getTypeKey(), k -> new Settings());
        }

        public boolean isDifferent(Config config) {
            return !this.getHash().equals(config.getHash());
        }

        public Map<String, Settings> getAllSettings() {
            return this.settings;
        }

        @NotNull
        public String getHash() {
            return Config.generateHash(this.settings);
        }

        public void layer(Map<String, Settings> settings) {
            this.settings.putAll(settings);
        }
    }
}

