/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.widget.OptionsListWidget;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdaptiveOptionsPanel
extends AbstractOptionsPanel {
    private static final Tooltip ADAPTIVE_INFO = Tooltip.m_257550_((Component)Component.m_237115_((String)"minecraft-cursor.options.adapt.tooltip"));
    private static final Component ITEM_SLOT = Component.m_237115_((String)"minecraft-cursor.options.adapt.item_slot");
    private static final Component ITEM_GRAB = Component.m_237115_((String)"minecraft-cursor.options.adapt.item_grab");
    private static final Component CREATIVE_TABS = Component.m_237115_((String)"minecraft-cursor.options.adapt.creative_tabs");
    private static final Component ENCHANTMENTS = Component.m_237115_((String)"minecraft-cursor.options.adapt.enchantments");
    private static final Component STONECUTTER = Component.m_237115_((String)"minecraft-cursor.options.adapt.stonecutter");
    private static final Component BOOK_EDIT = Component.m_237115_((String)"minecraft-cursor.options.adapt.book_edit");
    private static final Component LOOM = Component.m_237115_((String)"minecraft-cursor.options.adapt.loom");
    private static final Component ADVANCEMENTS = Component.m_237115_((String)"minecraft-cursor.options.adapt.advancements");
    private static final Component WORLD = Component.m_237115_((String)"minecraft-cursor.options.adapt.world");
    private static final Component SERVER = Component.m_237115_((String)"minecraft-cursor.options.adapt.server");
    private static final Component INACTIVE_WIDGETS = Component.m_237115_((String)"minecraft-cursor.options.adapt.inactive_widgets");
    private static final int CURSOR_SIZE_STEP = 8;
    private final CursorAnimationHelper animationHelper;
    private final Runnable refreshCursors;
    private OptionsListWidget optionsList;

    public AdaptiveOptionsPanel(Component title, CursorAnimationHelper animationHelper, Runnable refreshCursors) {
        super(title);
        this.animationHelper = animationHelper;
        this.refreshCursors = refreshCursors;
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), 20, this.getSpacing());
        boolean adaptive = CursorManager.INSTANCE.isAdaptive();
        this.optionsList.addToggle(adaptive, this::toggleAdaptive, ENABLE_TEXT, ADAPTIVE_INFO, true);
        this.addOption(MinecraftCursor.CONFIG.isItemSlotEnabled(), MinecraftCursor.CONFIG::setItemSlotEnabled, ITEM_SLOT, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isItemGrabbingEnabled(), MinecraftCursor.CONFIG::setItemGrabbingEnabled, ITEM_GRAB, CursorType.GRABBING, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isBookEditEnabled(), MinecraftCursor.CONFIG::setBookEditEnabled, BOOK_EDIT, CursorType.TEXT, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isInactiveWidgetsEnabled(), MinecraftCursor.CONFIG::setInactiveWidgetsEnabled, INACTIVE_WIDGETS, CursorType.NOT_ALLOWED, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isCreativeTabsEnabled(), MinecraftCursor.CONFIG::setCreativeTabsEnabled, CREATIVE_TABS, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isEnchantmentsEnabled(), MinecraftCursor.CONFIG::setEnchantmentsEnabled, ENCHANTMENTS, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isStonecutterRecipesEnabled(), MinecraftCursor.CONFIG::setStonecutterRecipesEnabled, STONECUTTER, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isLoomPatternsEnabled(), MinecraftCursor.CONFIG::setLoomPatternsEnabled, LOOM, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isAdvancementTabsEnabled(), MinecraftCursor.CONFIG::setAdvancementTabsEnabled, ADVANCEMENTS, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isWorldIconEnabled(), MinecraftCursor.CONFIG::setWorldIconEnabled, WORLD, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isServerIconEnabled(), MinecraftCursor.CONFIG::setServerIconEnabled, SERVER, CursorType.POINTER, adaptive);
        this.optionsList.search(this.getSearch());
        this.addRenderableWidget(this.optionsList);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, Component label, CursorType cursorType, boolean active) {
        this.optionsList.addToggle(value && active, consumer, this.index(label), this.prefixCursor(cursorType), null, active);
    }

    private OptionsListWidget.Prefix prefixCursor(CursorType cursorType) {
        Cursor cursor = Objects.requireNonNull(CursorManager.INSTANCE.getCursor(cursorType));
        return (guiGraphics, font, x, y, height) -> {
            int adjustedHeight = height - height % 8;
            int offsetY = y + (height - adjustedHeight) / 2;
            this.animationHelper.drawSprite(guiGraphics, cursor, x, offsetY, adjustedHeight);
            return adjustedHeight;
        };
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.setSize(this.getWidth(), this.computeMaxHeight(y));
            this.optionsList.m_264152_(x, y);
        }
    }

    @Override
    protected void searched(@NotNull String search, @Nullable Component matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }

    private void toggleAdaptive(boolean adaptive) {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            if (cursor.getType().isDefault()) continue;
            Cursor loadedCursor = cursor;
            if (adaptive && !cursor.isLoaded() && this.loadCursor(cursor)) {
                loadedCursor = Objects.requireNonNull(CursorManager.INSTANCE.getCursor(cursor.getType()));
            }
            loadedCursor.enable(adaptive);
            MinecraftCursor.CONFIG.getOrCreateSettings(loadedCursor).setEnabled(adaptive);
        }
        this.refreshCursors.run();
        this.refreshWidgets();
        this.repositionElements();
    }
}

