/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends Button {
    private static final int DEFAULT_SPRITE_SIZE = 16;
    @Nullable
    private ResourceLocation sprite;
    @Nullable
    private ResourceLocation inactiveSprite;
    private int textureWidth;
    private int textureHeight;

    public ButtonWidget(int x, int y, int width, int height, Component message, Runnable onPress) {
        super(x, y, width, height, message, btn -> onPress.run(), Button.f_252438_);
    }

    public ButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, Button.f_252438_);
    }

    public ButtonWidget(Component message, Runnable onPress) {
        this(0, 0, 150, 20, message, onPress);
    }

    public ButtonWidget(Component message, Button.OnPress onPress) {
        this(0, 0, 150, 20, message, onPress);
    }

    public ButtonWidget withSize(int size) {
        this.setSize(size, size);
        return this;
    }

    public ButtonWidget withTooltip(@Nullable Tooltip tooltip) {
        this.m_257544_(tooltip);
        return this;
    }

    public ButtonWidget withTooltip(@NotNull Component message) {
        this.m_257544_(Tooltip.m_257550_((Component)message));
        return this;
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public void setSize(int width, int height) {
        this.m_93674_(width);
        this.setHeight(height);
    }

    public ButtonWidget spriteOnly(@NotNull ResourceLocation sprite, ResourceLocation inactiveSprite, int textureWidth, int textureHeight) {
        this.sprite = sprite;
        this.inactiveSprite = inactiveSprite;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        return this;
    }

    public ButtonWidget spriteOnly(@NotNull ResourceLocation sprite) {
        return this.spriteOnly(sprite, sprite, 16, 16);
    }

    public ButtonWidget spriteOnly(@NotNull ResourceLocation sprite, ResourceLocation inactiveSprite) {
        return this.spriteOnly(sprite, inactiveSprite, 16, 16);
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.m_93692_(false);
    }

    protected void m_280372_(@NotNull GuiGraphics guiGraphics, @NotNull Font font, int width, int color) {
        if (this.sprite == null) {
            super.m_280372_(guiGraphics, font, width, color);
        }
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.sprite != null) {
            ResourceLocation currentSprite = this.f_93623_ ? this.sprite : Objects.requireNonNullElse(this.inactiveSprite, this.sprite);
            int spriteWidth = Math.min(this.m_5711_(), this.textureWidth);
            int spriteHeight = Math.min(this.m_93694_(), this.textureHeight);
            int spriteX = this.m_252754_() + (this.m_5711_() - spriteWidth) / 2;
            int spriteY = this.m_252907_() + (this.m_93694_() - spriteHeight) / 2;
            guiGraphics.m_280411_(currentSprite, spriteX, spriteY, spriteWidth, spriteHeight, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
        }
    }
}

