/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.impl;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.api.MinecraftCursorInitializer;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;

public final class MinecraftCursorInitializerImpl
implements MinecraftCursorInitializer {
    public void init(CursorTypeRegistrar cursorRegistrar, ElementRegistrar elementRegistrar) {
        cursorRegistrar.register(new CursorType[]{CursorType.DEFAULT, CursorType.POINTER, CursorType.GRABBING, CursorType.TEXT, CursorType.SHIFT, CursorType.BUSY, CursorType.NOT_ALLOWED, CursorType.CROSSHAIR, CursorType.RESIZE_EW, CursorType.RESIZE_NS, CursorType.RESIZE_NWSE, CursorType.RESIZE_NESW});
        elementRegistrar.register(ReceivingLevelScreen.class, this::elementToBusy);
        elementRegistrar.register(ProgressScreen.class, this::elementToBusy);
        elementRegistrar.register(LevelLoadingScreen.class, this::elementToBusy);
        elementRegistrar.register(AbstractButton.class, this::buttonWidgetCursor);
        elementRegistrar.register(TabButton.class, this::tabButtonWidgetCursor);
        elementRegistrar.register(AbstractSliderButton.class, this::sliderWidgetCursor);
        elementRegistrar.register(EditBox.class, this::textFieldWidgetCursor);
        elementRegistrar.register(MultiLineEditBox.class, this::textFieldWidgetCursor);
    }

    private CursorType elementToBusy(GuiEventListener ignoreElement, double ignoreMouseX, double ignoreMouseY) {
        return CursorType.BUSY;
    }

    private CursorType buttonWidgetCursor(AbstractButton button, double mouseX, double mouseY) {
        if (button.f_93624_ && button.m_274382_()) {
            return MinecraftCursorInitializerImpl.inactiveButtonCursor((AbstractWidget)button);
        }
        return CursorType.DEFAULT;
    }

    private CursorType tabButtonWidgetCursor(TabButton tabButton, double mouseX, double mouseY) {
        return tabButton.f_93623_ && tabButton.f_93624_ && tabButton.m_274382_() && !tabButton.m_274319_() ? CursorType.POINTER : CursorType.DEFAULT;
    }

    private CursorType sliderWidgetCursor(AbstractSliderButton slider, double mouseX, double mouseY) {
        if (slider.m_93696_() && (CursorTypeUtil.isLeftClickHeld() || CursorTypeUtil.isGrabbing())) {
            return CursorType.GRABBING;
        }
        return slider.f_93624_ ? MinecraftCursorInitializerImpl.inactiveButtonCursor((AbstractWidget)slider) : CursorType.DEFAULT;
    }

    private CursorType textFieldWidgetCursor(AbstractWidget textField, double mouseX, double mouseY) {
        return textField.f_93624_ && textField.f_93623_ && textField.m_274382_() ? CursorType.TEXT : CursorType.DEFAULT;
    }

    private static CursorType inactiveButtonCursor(AbstractWidget button) {
        if (button.f_93623_) {
            return CursorType.POINTER;
        }
        if (MinecraftCursor.CONFIG.isInactiveWidgetsEnabled()) {
            return CursorType.NOT_ALLOWED;
        }
        return CursorType.DEFAULT;
    }
}

