/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.util;

import dev.kosmx.playerAnim.core.util.Vector3;

public class Vec3d
extends Vector3<Double> {
    public Vec3d(Double x, Double y, Double z) {
        super(x, y, z);
    }

    public double squaredDistanceTo(Vec3d vec3d) {
        double a = (Double)this.x - (Double)vec3d.x;
        double b = (Double)this.y - (Double)vec3d.y;
        double c = (Double)this.z - (Double)vec3d.z;
        return a * a + b * b + c * c;
    }

    public Vec3d scale(double scalar) {
        return new Vec3d((Double)this.getX() * scalar, (Double)this.getY() * scalar, (Double)this.getZ() * scalar);
    }

    public Vec3d add(Vec3d other) {
        return new Vec3d((Double)this.getX() + (Double)other.getX(), (Double)this.getY() + (Double)other.getY(), (Double)this.getZ() + (Double)other.getZ());
    }

    public double dotProduct(Vec3d other) {
        return (Double)this.getX() * (Double)other.getX() + (Double)this.getY() * (Double)other.getY() + (Double)this.getZ() * (Double)other.getZ();
    }

    public Vec3d crossProduct(Vec3d other) {
        return new Vec3d((Double)this.getY() * (Double)other.getZ() - (Double)this.getZ() * (Double)other.getY(), (Double)this.getZ() * (Double)other.getX() - (Double)this.getX() * (Double)other.getZ(), (Double)this.getX() * (Double)other.getY() - (Double)this.getY() * (Double)other.getX());
    }

    public Vec3d subtract(Vec3d rhs) {
        return this.add(rhs.scale(-1.0));
    }

    public double distanceTo(Vec3d vec3d) {
        return Math.sqrt(this.squaredDistanceTo(vec3d));
    }
}

