/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.simple.DeferralBehaviour;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ChamberOperatingBlockEntity
extends KineticBlockEntity {
    public DeferralBehaviour chamberChecker;
    public boolean chamberRemoved;
    protected Recipe<?> currentRecipe;

    public ChamberOperatingBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.chamberChecker = new DeferralBehaviour((SmartBlockEntity)this, this::updateChamber);
        behaviours.add((BlockEntityBehaviour)this.chamberChecker);
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.chamberRemoved = true;
        }
        this.chamberRemoved = false;
        this.chamberChecker.scheduleUpdate();
    }

    public void tick() {
        if (this.chamberRemoved) {
            this.chamberRemoved = false;
            this.onChamberRemoved();
            this.sendData();
            return;
        }
        super.tick();
    }

    protected boolean updateChamber() {
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return true;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return true;
        }
        Optional<ChamberBlockEntity> chamber = this.getChamber();
        if (chamber.filter(ChamberBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = recipes.get(0);
        this.startProcessingChamber();
        this.sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingChamber() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    protected <C extends Container> boolean matchChamberRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional<ChamberBlockEntity> chamber = this.getChamber();
        return chamber.filter(chamberBlockEntity -> ChamberRecipe.match(chamberBlockEntity, recipe)).isPresent();
    }

    protected void applyChamberRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional<ChamberBlockEntity> optionalChamber = this.getChamber();
        if (optionalChamber.isEmpty()) {
            return;
        }
        ChamberBlockEntity chamber = optionalChamber.get();
        boolean wasEmpty = chamber.canContinueProcessing();
        if (!ChamberRecipe.apply(chamber, this.currentRecipe)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((ChamberOperatingBlockEntity)this).award(arg_0));
        chamber.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchChamberRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        chamber.notifyChangeOfContents();
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        Optional<ChamberBlockEntity> chamber = this.getChamber();
        if (chamber.map(ChamberBlockEntity::getTop).map(ChamberBlockEntity::isEmpty).orElse(true).booleanValue() && chamber.map(ChamberBlockEntity::getMiddle).map(ChamberBlockEntity::isEmpty).orElse(true).booleanValue() && chamber.map(ChamberBlockEntity::getBottom).map(ChamberBlockEntity::isEmpty).orElse(true).booleanValue()) {
            return new ArrayList();
        }
        return this.getAllRecipes().stream().filter(this::matchChamberRecipe).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).collect(Collectors.toList());
    }

    protected List<Recipe<?>> getAllRecipes() {
        return RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, this::matchStaticFilters);
    }

    protected abstract void onChamberRemoved();

    protected abstract Optional<ChamberBlockEntity> getChamber();

    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.empty();
    }

    protected abstract <C extends Container> boolean matchStaticFilters(Recipe<C> var1);

    protected abstract Object getRecipeCacheKey();
}

