/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.shrieker;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.dragonegg.sculkcatalyticchamber.SCCConfig;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberOperatingBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.shrieker.MechanicalShriekerBlock;
import net.dragonegg.sculkcatalyticchamber.content.shrieker.MechanicalShriekerParticleData;
import net.dragonegg.sculkcatalyticchamber.registry.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MechanicalShriekerBlockEntity
extends ChamberOperatingBlockEntity
implements IHaveGoggleInformation {
    private static final Object shriekerCacheKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public int renderingTicks;
    public boolean running;

    public MechanicalShriekerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.runningTicks = compound.m_128451_("Ticks");
        super.read(compound, clientPacket);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128405_("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.chamberChecker.scheduleUpdate();
            return;
        }
        if (!this.running && this.f_58857_ != null && ((Boolean)this.m_58900_().m_61143_((Property)MechanicalShriekerBlock.SHRIEKING)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MechanicalShriekerBlock.SHRIEKING, (Comparable)Boolean.valueOf(false)), 2);
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.f_58857_ != null) {
            if (!((Boolean)this.m_58900_().m_61143_((Property)MechanicalShriekerBlock.SHRIEKING)).booleanValue()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MechanicalShriekerBlock.SHRIEKING, (Comparable)Boolean.valueOf(true)), 2);
            }
            if (this.f_58857_.f_46443_ && this.renderingTicks == 20) {
                this.renderParticles((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING));
                this.renderingTicks = 0;
            }
            if ((!this.f_58857_.f_46443_ || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    float recipeSpeed = 1.0f;
                    int t = (Integer)SCCConfig.CHAMBER_SPEED.get();
                    if (t != 0) {
                        recipeSpeed = (float)t / 100.0f;
                    }
                    this.processingTicks = Mth.m_14045_((int)(Mth.m_14173_((int)((int)(512.0f / speed))) * Mth.m_14167_((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, speed < 65.0f ? 0.75f : 1.5f);
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyChamberRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
            if (this.renderingTicks != 20) {
                ++this.renderingTicks;
            }
        }
    }

    private void renderParticles(Direction direction) {
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.m_58899_());
        for (int j1 = 0; j1 < 4; ++j1) {
            this.f_58857_.m_6493_((ParticleOptions)new MechanicalShriekerParticleData(j1 * 5, direction), false, c.m_7096_(), c.m_7098_(), c.m_7094_(), 0.0, 0.0, 0.0);
        }
        c = c.m_82520_(0.0, -3.0, 0.0);
        RandomSource r = this.f_58857_.f_46441_;
        for (int i = 0; i < 10; ++i) {
            Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_();
            Vec3 v = c.m_82549_(offset.m_82490_(0.5 + r.m_188500_() * 0.125)).m_82520_(0.0, 0.125, 0.0);
            Vec3 m = offset.m_82490_(0.03125);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_235898_, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Override
    public void startProcessingChamber() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingChamber();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    @Override
    protected void onChamberRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Optional<ChamberBlockEntity> getChamber() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_6625_(2));
        if (!(be instanceof ChamberBlockEntity)) {
            return Optional.empty();
        }
        ChamberBlockEntity chamber = (ChamberBlockEntity)be;
        return Optional.of(chamber);
    }

    @Override
    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == RecipeRegistry.CHAMBER.getType();
    }

    @Override
    protected Object getRecipeCacheKey() {
        return shriekerCacheKey;
    }
}

