/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.sittingplus;

import com.mojang.blaze3d.platform.InputConstants;
import com.saltywater.sittingplus.SittingPlusConfig;
import com.saltywater.sittingplus.networking.SittingPlusNetworking;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="sittingplus", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SittingPlusClient {
    private static KeyMapping sitKey;
    private static KeyframeAnimationPlayer sitAnimationPlayer;
    private static CameraType previousCameraType;
    private int animationState = 0;
    private static final ResourceLocation[] ANIMATION_IDS_STAIRS;
    private static final ResourceLocation[] ANIMATION_IDS_GROUND;
    private static final ResourceLocation[] ANIMATION_IDS_FENCES;
    private static final ResourceLocation[] ANIMATION_IDS_BEDS;
    private static final ResourceLocation[] ANIMATION_IDS_SWORD;
    private static final ResourceLocation[] ANIMATION_IDS_AXE;
    private static final ResourceLocation[] ANIMATION_IDS_SHOVEL;
    private static final ResourceLocation[] ANIMATION_IDS_FISHING_ROD;

    public static void registerClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SittingPlusClient::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)new SittingPlusClient());
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        sitKey = new KeyMapping("Sit", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.m_84895_(88), "key.categories.movement");
        Minecraft.m_91087_().f_91066_.f_92059_ = SittingPlusClient.appendKeyBinding(Minecraft.m_91087_().f_91066_.f_92059_, sitKey);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!SittingPlusConfig.getConfig().enableClickToSit) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof LocalPlayer) {
            LocalPlayer player2 = (LocalPlayer)player;
            if (event.getLevel().f_46443_) {
                if (!player2.m_21205_().m_41619_() && player2.m_21205_().m_41720_() instanceof BlockItem) {
                    return;
                }
                BlockPos blockPos = event.getPos();
                BlockState blockState = event.getLevel().m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (block instanceof StairBlock) {
                    double offset = 0.3;
                    double x = (double)blockPos.m_123341_() + 0.5;
                    double y = (double)blockPos.m_123342_() + 1.0;
                    double z = (double)blockPos.m_123343_() + 0.5;
                    switch ((Direction)blockState.m_61143_((Property)StairBlock.f_56841_)) {
                        case NORTH: {
                            z += offset;
                            break;
                        }
                        case SOUTH: {
                            z -= offset;
                            break;
                        }
                        case WEST: {
                            x += offset;
                            break;
                        }
                        case EAST: {
                            x -= offset;
                        }
                    }
                    player2.m_6034_(x, y, z);
                    switch ((Direction)blockState.m_61143_((Property)StairBlock.f_56841_)) {
                        case NORTH: {
                            player2.m_146922_(0.0f);
                            break;
                        }
                        case SOUTH: {
                            player2.m_146922_(180.0f);
                            break;
                        }
                        case WEST: {
                            player2.m_146922_(270.0f);
                            break;
                        }
                        case EAST: {
                            player2.m_146922_(90.0f);
                        }
                    }
                    player2.m_146926_(0.0f);
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player2);
                    if (animationStack != null) {
                        this.stopCurrentAnimation(animationStack);
                        this.animationState = 0;
                        this.playAnimation(animationStack, ANIMATION_IDS_STAIRS);
                        this.setThirdPersonIfEnabled();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.Key event) {
        if (sitKey.m_90857_()) {
            Item heldItem;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
            if (animationStack == null) {
                return;
            }
            this.stopCurrentAnimation(animationStack);
            Vec3 start = player.m_20299_(1.0f);
            Vec3 direction = player.m_20252_(1.0f).m_82490_(2.0);
            Vec3 end = start.m_82549_(direction);
            BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = hitResult.m_82425_();
                Block block = player.m_9236_().m_8055_(blockPos).m_60734_();
                if (block instanceof CampfireBlock) {
                    this.playAnimation(animationStack, new ResourceLocation[]{new ResourceLocation("sittingplus", "campfiresit")});
                    this.setThirdPersonIfEnabled();
                    return;
                }
                if (block instanceof FurnaceBlock) {
                    this.playAnimation(animationStack, new ResourceLocation[]{new ResourceLocation("sittingplus", "furnacesit")});
                    this.setThirdPersonIfEnabled();
                    return;
                }
            }
            if ((heldItem = player.m_21205_().m_41720_()) instanceof SwordItem) {
                this.playAnimation(animationStack, ANIMATION_IDS_SWORD);
                return;
            }
            if (heldItem instanceof AxeItem) {
                this.playAnimation(animationStack, ANIMATION_IDS_AXE);
                return;
            }
            if (heldItem instanceof ShovelItem) {
                this.playAnimation(animationStack, ANIMATION_IDS_SHOVEL);
                return;
            }
            if (heldItem instanceof FishingRodItem) {
                this.playAnimation(animationStack, ANIMATION_IDS_FISHING_ROD);
                return;
            }
            start = player.m_20182_();
            BlockHitResult result = Minecraft.m_91087_().f_91073_.m_45547_(new ClipContext(start, end = new Vec3(player.m_20185_(), player.m_20186_() - 1.5, player.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = result.m_82425_();
                BlockState blockState = Minecraft.m_91087_().f_91073_.m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (block instanceof StairBlock) {
                    this.playAnimation(animationStack, ANIMATION_IDS_STAIRS);
                    this.setThirdPersonIfEnabled();
                    return;
                }
                if (block instanceof FenceBlock) {
                    this.playAnimation(animationStack, ANIMATION_IDS_FENCES);
                    this.setThirdPersonIfEnabled();
                    return;
                }
                if (block instanceof BedBlock) {
                    this.playAnimation(animationStack, ANIMATION_IDS_BEDS);
                    this.setThirdPersonIfEnabled();
                    return;
                }
                this.playAnimation(animationStack, ANIMATION_IDS_GROUND);
                this.setThirdPersonIfEnabled();
                return;
            }
            this.playAnimation(animationStack, ANIMATION_IDS_GROUND);
            this.setThirdPersonIfEnabled();
        }
    }

    @SubscribeEvent
    public void onPlayerMove(MovementInputUpdateEvent event) {
        AnimationStack animationStack;
        boolean isMoving;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean bl = isMoving = player.f_108618_.f_108567_ != 0.0f || player.f_108618_.f_108566_ != 0.0f || player.f_108618_.f_108572_ || player.f_108618_.f_108573_;
        if (isMoving && (animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player)) != null) {
            this.stopCurrentAnimation(animationStack);
            this.animationState = 0;
        }
    }

    @SubscribeEvent
    public void onRenderLevel(RenderLevelStageEvent event) {
        if (!(sitAnimationPlayer == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY || SittingPlusConfig.getConfig().onlyLowerCameraInFirstPerson && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON)) {
            event.getPoseStack().m_85837_(0.0, 0.7, 0.0);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        AnimationStack animationStack;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !Minecraft.m_91087_().m_91302_()) {
            return;
        }
        long afkTimeoutMs = (long)SittingPlusConfig.getConfig().afkSitDelaySeconds * 1000L;
        long now = System.currentTimeMillis();
        if (now - afkTimeoutMs >= now && sitAnimationPlayer == null && (animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player)) != null) {
            this.playAnimation(animationStack, ANIMATION_IDS_GROUND);
            this.setThirdPersonIfEnabled();
        }
    }

    private void setThirdPersonIfEnabled() {
        if (SittingPlusConfig.getConfig().enableThirdPersonOnSit) {
            CameraType current = Minecraft.m_91087_().f_91066_.m_92176_();
            if (current == CameraType.FIRST_PERSON) {
                previousCameraType = current;
                Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            } else {
                previousCameraType = null;
            }
        }
    }

    private void playAnimation(AnimationStack animationStack, ResourceLocation[] animations) {
        ResourceLocation animationId;
        KeyframeAnimation animationData;
        if (animations == null || animations.length == 0) {
            return;
        }
        if (this.animationState < 0 || this.animationState >= animations.length) {
            this.animationState = 0;
        }
        if ((animationData = PlayerAnimationRegistry.getAnimation((ResourceLocation)(animationId = animations[this.animationState]))) == null) {
            return;
        }
        sitAnimationPlayer = new KeyframeAnimationPlayer(animationData);
        animationStack.addAnimLayer(0, (IAnimation)sitAnimationPlayer);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            SittingPlusNetworking.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SittingPlusNetworking.StartSitPacket(player.m_20148_().toString(), animationId));
        }
        this.animationState = (this.animationState + 1) % animations.length;
    }

    private void stopCurrentAnimation(AnimationStack animationStack) {
        if (sitAnimationPlayer == null || animationStack == null) {
            return;
        }
        animationStack.removeLayer(0);
        sitAnimationPlayer = null;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            SittingPlusNetworking.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SittingPlusNetworking.StopSitPacket(player.m_20148_().toString()));
            if (SittingPlusConfig.getConfig().enableThirdPersonOnSit && previousCameraType != null) {
                Minecraft.m_91087_().f_91066_.m_92157_(previousCameraType);
                previousCameraType = null;
            }
        }
    }

    private static KeyMapping[] appendKeyBinding(KeyMapping[] existingKeyMappings, KeyMapping newKeyMapping) {
        if (existingKeyMappings == null || newKeyMapping == null) {
            return existingKeyMappings;
        }
        KeyMapping[] newArray = new KeyMapping[existingKeyMappings.length + 1];
        System.arraycopy(existingKeyMappings, 0, newArray, 0, existingKeyMappings.length);
        newArray[existingKeyMappings.length] = newKeyMapping;
        return newArray;
    }

    static {
        previousCameraType = null;
        ANIMATION_IDS_STAIRS = new ResourceLocation[]{new ResourceLocation("sittingplus", "chairsitting"), new ResourceLocation("sittingplus", "chairsitting2"), new ResourceLocation("sittingplus", "chairsitting3"), new ResourceLocation("sittingplus", "chairsitting4")};
        ANIMATION_IDS_GROUND = new ResourceLocation[]{new ResourceLocation("sittingplus", "kneesitting"), new ResourceLocation("sittingplus", "buttsit"), new ResourceLocation("sittingplus", "buttsit2"), new ResourceLocation("sittingplus", "kneeleaning")};
        ANIMATION_IDS_FENCES = new ResourceLocation[]{new ResourceLocation("sittingplus", "fencesitting"), new ResourceLocation("sittingplus", "fencesitting2")};
        ANIMATION_IDS_BEDS = new ResourceLocation[]{new ResourceLocation("sittingplus", "bedlyingdown"), new ResourceLocation("sittingplus", "bedlyingdown2"), new ResourceLocation("sittingplus", "bedlyingdown3")};
        ANIMATION_IDS_SWORD = new ResourceLocation[]{new ResourceLocation("sittingplus", "swordsit"), new ResourceLocation("sittingplus", "swordsit2")};
        ANIMATION_IDS_AXE = new ResourceLocation[]{new ResourceLocation("sittingplus", "sittingaxe")};
        ANIMATION_IDS_SHOVEL = new ResourceLocation[]{new ResourceLocation("sittingplus", "sittingshovel")};
        ANIMATION_IDS_FISHING_ROD = new ResourceLocation[]{new ResourceLocation("sittingplus", "fishing")};
    }
}

