/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.diagonal;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.connection.diagonal.DiagonalCableBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DiagonalCableBlock
extends Block
implements SimpleWaterloggedBlock,
IWrenchable,
IBE<DiagonalCableBlockEntity> {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING_PRIMARY = DirectionProperty.m_156003_((String)"facing_primary");
    public static final DirectionProperty FACING_SECONDARY = DirectionProperty.m_156003_((String)"facing_secondary");

    public DiagonalCableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING_PRIMARY, (Comparable)Direction.NORTH)).m_61124_((Property)FACING_SECONDARY, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING_PRIMARY, FACING_SECONDARY});
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public void m_6807_(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean secondaryIsVertical;
        Direction primary = (Direction)state.m_61143_((Property)FACING_PRIMARY);
        Direction secondary = (Direction)state.m_61143_((Property)FACING_SECONDARY);
        boolean primaryIsVertical = primary.m_122434_() == Direction.Axis.Y;
        boolean bl = secondaryIsVertical = secondary.m_122434_() == Direction.Axis.Y;
        if (primaryIsVertical || secondaryIsVertical) {
            Direction vertical = primaryIsVertical ? primary : secondary;
            Direction horizontal = primaryIsVertical ? secondary : primary;
            return vertical == Direction.UP ? TFMGShapes.DIAGONAL_CABLE_BLOCK_UP.get(horizontal) : TFMGShapes.DIAGONAL_CABLE_BLOCK_DOWN.get(horizontal);
        }
        boolean isClockwise = this.isClockwisePair(primary, secondary);
        Direction shapeDirection = isClockwise ? primary : secondary;
        return TFMGShapes.DIAGONAL_CABLE_BLOCK_HORIZONTAL.get(shapeDirection);
    }

    private boolean isClockwisePair(Direction a, Direction b) {
        return a == Direction.NORTH && b == Direction.EAST || a == Direction.EAST && b == Direction.SOUTH || a == Direction.SOUTH && b == Direction.WEST || a == Direction.WEST && b == Direction.NORTH;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        if (!result.m_19077_()) {
            return result;
        }
        Direction clickedFace = context.m_43719_();
        Direction primary = (Direction)state.m_61143_((Property)FACING_PRIMARY);
        Direction secondary = (Direction)state.m_61143_((Property)FACING_SECONDARY);
        BlockState newState = this.calculateRotatedState(state, clickedFace, primary, secondary);
        context.m_43725_().m_7731_(context.m_8083_(), newState, 3);
        this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), IElectric::onPlaced);
        IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
        return result;
    }

    private BlockState calculateRotatedState(BlockState currentState, Direction clickedFace, Direction primary, Direction secondary) {
        if (clickedFace == primary) {
            return (BlockState)currentState.m_61124_((Property)FACING_PRIMARY, (Comparable)clickedFace.m_122424_());
        }
        if (clickedFace == secondary) {
            return (BlockState)currentState.m_61124_((Property)FACING_SECONDARY, (Comparable)clickedFace.m_122424_());
        }
        if (clickedFace == primary.m_122424_()) {
            return (BlockState)currentState.m_61124_((Property)FACING_SECONDARY, (Comparable)this.rotateAroundAxis(secondary, primary.m_122434_()));
        }
        if (clickedFace == secondary.m_122424_()) {
            return (BlockState)currentState.m_61124_((Property)FACING_PRIMARY, (Comparable)this.rotateAroundAxis(primary, secondary.m_122434_()));
        }
        return (BlockState)((BlockState)currentState.m_61124_((Property)FACING_PRIMARY, (Comparable)this.rotateAroundAxis(primary, clickedFace.m_122434_()))).m_61124_((Property)FACING_SECONDARY, (Comparable)this.rotateAroundAxis(secondary, clickedFace.m_122434_()));
    }

    private Direction rotateAroundAxis(Direction direction, Direction.Axis axis) {
        if (direction.m_122434_() == axis) {
            return direction;
        }
        return direction.m_175362_(axis);
    }

    public BlockState m_7417_(BlockState p_51461_, Direction p_51462_, BlockState p_51463_, LevelAccessor p_51464_, BlockPos p_51465_, BlockPos p_51466_) {
        if (((Boolean)p_51461_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51464_.m_186469_(p_51465_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51464_));
        }
        return super.m_7417_(p_51461_, p_51462_, p_51463_, p_51464_, p_51465_, p_51466_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        Direction facing = Objects.requireNonNull(context.m_43723_()).m_6350_();
        Direction clickedFace = context.m_43719_();
        if (context.m_43723_() != null) {
            if (clickedFace.m_122434_() == Direction.Axis.Y) {
                return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING_PRIMARY, (Comparable)clickedFace.m_122424_())).m_61124_((Property)FACING_SECONDARY, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING_PRIMARY, (Comparable)facing)).m_61124_((Property)FACING_SECONDARY, (Comparable)facing.m_175362_(Direction.Axis.Y))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING_PRIMARY, (Comparable)Direction.UP)).m_61124_((Property)FACING_SECONDARY, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public Class<DiagonalCableBlockEntity> getBlockEntityClass() {
        return DiagonalCableBlockEntity.class;
    }

    public BlockEntityType<? extends DiagonalCableBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.DIAGONAL_CABLE_BLOCK.get();
    }
}

