/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.render.gui.particle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.client.render.gui.particle.ScreenParticleHolder;

public class ParticleEmitterHandler {
    public static final Map<Item, List<IGUIParticleItem>> EMITTERS = new HashMap<Item, List<IGUIParticleItem>>();

    public static void registerEmitters(FMLClientSetupEvent event) {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!(item instanceof IGUIParticleItem)) continue;
            IGUIParticleItem supplier = (IGUIParticleItem)item;
            ParticleEmitterHandler.registerEmitters(item, supplier);
        }
    }

    public static void registerEmitters(Item item, IGUIParticleItem emitter) {
        if (EMITTERS.containsKey(item)) {
            EMITTERS.get(item).add(emitter);
        } else {
            EMITTERS.put(item, new ArrayList<IGUIParticleItem>(List.of(emitter)));
        }
    }

    public static void registerEmitters(IGUIParticleItem emitter, Item ... items) {
        for (Item item : items) {
            ParticleEmitterHandler.registerEmitters(item, emitter);
        }
    }

    public static interface IGUIParticleItem {
        default public void spawnParticlesEarly(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        }

        default public void spawnParticlesLate(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        }
    }
}

