/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.book;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.client.model.TridotModels;
import pro.komaru.tridot.client.model.book.CustomBookModel;
import pro.komaru.tridot.common.registry.book.BookComponent;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public abstract class Book {
    public ArcRandom random = Tmp.rnd;
    public ItemStack book;

    public Book(ItemStack book) {
        this.book = book;
    }

    public ItemStack getBook() {
        return this.book;
    }

    public boolean hasBook(ItemStack book) {
        return book.m_150930_(this.book.m_41720_());
    }

    public BookComponent getComponent() {
        return new BookComponent();
    }

    public abstract ResourceLocation getTexture(Level var1, Vec3 var2, ItemStack var3, BookComponent var4);

    @OnlyIn(value=Dist.CLIENT)
    public CustomBookModel getModel(Level level, Vec3 pos, ItemStack stack, BookComponent component) {
        return TridotModels.BOOK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void openGui(Level var1, ItemStack var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void openGui(Level var1, Vec3 var2, ItemStack var3);

    public void tick(Level level, Vec3 pos, ItemStack stack, BookComponent component, double distance) {
        float f2;
        component.oOpen = component.open;
        component.oRot = component.rot;
        Player player = level.m_45924_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), distance, false);
        if (player != null) {
            double d0 = player.m_20185_() - pos.m_7096_();
            double d1 = player.m_20189_() - pos.m_7094_();
            component.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
            component.open += 0.1f;
            if (component.open < 0.5f || this.random.nextInt(40) == 0) {
                float f1 = component.flipT;
                do {
                    component.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
                } while (f1 == component.flipT);
            }
        } else {
            component.tRot += 0.02f;
            component.open -= 0.1f;
        }
        while (component.rot >= (float)Math.PI) {
            component.rot -= (float)Math.PI * 2;
        }
        while (component.rot < (float)(-Math.PI)) {
            component.rot += (float)Math.PI * 2;
        }
        while (component.tRot >= (float)Math.PI) {
            component.tRot -= (float)Math.PI * 2;
        }
        while (component.tRot < (float)(-Math.PI)) {
            component.tRot += (float)Math.PI * 2;
        }
        for (f2 = component.tRot - component.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        component.rot += f2 * 0.4f;
        component.open = Mth.m_14036_((float)component.open, (float)0.0f, (float)1.0f);
        ++component.time;
        component.oFlip = component.flip;
        float f = (component.flipT - component.flip) * 0.4f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        component.flipA += (f - component.flipA) * 0.9f;
        component.flip += component.flipA;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupAnim(Level level, Vec3 pos, ItemStack stack, BookComponent component, CustomBookModel model, float partialTicks) {
        float f = (float)component.time + partialTicks;
        float f3 = Mth.m_14179_((float)partialTicks, (float)component.oFlip, (float)component.flip);
        float f4 = Mth.m_14187_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.m_14187_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14179_((float)partialTicks, (float)component.oOpen, (float)component.open);
        model.setupAnim(f, Mth.m_14036_((float)f4, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), f6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderModel(Level level, Vec3 pos, ItemStack stack, BookComponent component, CustomBookModel model, ResourceLocation texture, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        model.render(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)texture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(Level level, Vec3 pos, ItemStack stack, BookComponent component, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        CustomBookModel model = this.getModel(level, pos, stack, component);
        ResourceLocation texture = this.getTexture(level, pos, stack, component);
        this.setupAnim(level, pos, stack, component, model, partialTicks);
        this.renderModel(level, pos, stack, component, model, texture, partialTicks, poseStack, bufferSource, light, overlay);
    }
}

