/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import pro.komaru.tridot.api.entity.AttackRegistry;

public abstract class MultiAttackMob
extends PathfinderMob {
    private static final EntityDataAccessor<String> DATA_ID = SynchedEntityData.m_135353_(MultiAttackMob.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected int preparingTickCount;
    protected int globalCooldown;
    protected int attackWarmupDelay;
    protected int attackAnimationTick;
    public AttackRegistry currentAttack = AttackRegistry.NONE;

    public MultiAttackMob(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID, (Object)AttackRegistry.NONE.toString());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.preparingTickCount = pCompound.m_128451_("PrepareTicks");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("PrepareTicks", this.preparingTickCount);
    }

    public boolean isPreparingAttack() {
        if (this.m_9236_().f_46443_) {
            return !((String)this.f_19804_.m_135370_(DATA_ID)).equals("none");
        }
        return this.preparingTickCount > 0;
    }

    public boolean hasTarget() {
        return this.m_5448_() != null;
    }

    public int getPreparingTime() {
        return this.preparingTickCount;
    }

    public AttackRegistry getCurrentAttack() {
        return !this.m_9236_().f_46443_ ? this.currentAttack : AttackRegistry.byId((String)this.f_19804_.m_135370_(DATA_ID));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
            if (this.attackAnimationTick == this.attackDelay() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_217066_(this.m_5448_())) {
                this.performMeleeAttack();
            }
        }
    }

    public void performMeleeAttack() {
        this.m_6674_(InteractionHand.MAIN_HAND);
        this.m_7327_((Entity)this.m_5448_());
        this.m_5496_(this.attackSound(), 1.0f, 1.0f);
    }

    public int attackDelay() {
        return 5;
    }

    public SoundEvent attackSound() {
        return SoundEvents.f_12316_;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.globalCooldown > 0) {
            --this.globalCooldown;
        }
        if (this.attackWarmupDelay > 0) {
            --this.attackWarmupDelay;
        }
        if (this.preparingTickCount > 0) {
            --this.preparingTickCount;
        }
    }

    public void setCurrentAttack(AttackRegistry pCurrentAttack) {
        this.currentAttack = pCurrentAttack;
        this.f_19804_.m_135381_(DATA_ID, (Object)pCurrentAttack.getId());
    }

    public boolean isFleeing(Mob mob, float dist) {
        return mob.m_21573_().m_26570_() != null && mob.m_21573_().m_26570_().m_77407_() > dist;
    }

    public boolean cantReachTarget(LivingEntity target) {
        Path path = this.f_21344_.m_6570_((Entity)target, 1);
        return path == null;
    }

    public abstract class AttackGoal
    extends Goal {
        protected int nextAttackTickCount;

        public boolean m_8036_() {
            LivingEntity livingentity = MultiAttackMob.this.m_5448_();
            if (MultiAttackMob.this.hasTarget() && livingentity.m_6084_()) {
                if (MultiAttackMob.this.isPreparingAttack()) {
                    return false;
                }
                return MultiAttackMob.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = MultiAttackMob.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && MultiAttackMob.this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            MultiAttackMob.this.m_21561_(true);
            MultiAttackMob.this.setCurrentAttack(this.getAttack());
            MultiAttackMob.this.preparingTickCount = this.getPreparingTime();
            this.nextAttackTickCount = MultiAttackMob.this.f_19797_ + this.getAttackInterval();
            SoundEvent soundevent = this.getPrepareSound();
            this.onPrepare();
            if (soundevent != null) {
                MultiAttackMob.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            MultiAttackMob.this.m_21561_(false);
            super.m_8041_();
        }

        public void m_8037_() {
            if (MultiAttackMob.this.attackWarmupDelay == 0 && MultiAttackMob.this.globalCooldown == 0) {
                this.performAttack();
                MultiAttackMob.this.attackWarmupDelay = this.m_183277_(this.getPreparingTime());
                MultiAttackMob.this.globalCooldown = 20;
                MultiAttackMob.this.m_5496_(this.getAttackSound(), 1.0f, 1.0f);
            }
        }

        public abstract void onPrepare();

        protected abstract void performAttack();

        public abstract int getPreparingTime();

        public abstract int getAttackInterval();

        @Nullable
        public abstract SoundEvent getPrepareSound();

        public SoundEvent getAttackSound() {
            return SoundEvents.f_271165_;
        }

        public abstract AttackRegistry getAttack();
    }

    public abstract class TridotMeleeAttackGoal
    extends AttackGoal {
        public final MultiAttackMob mob;
        public final double speedModifier;
        public int ticksUntilNextPathRecalc;
        public double lastTargetX;
        public double lastTargetY;
        public double lastTargetZ;

        public TridotMeleeAttackGoal(MultiAttackMob mob, double speedModifier) {
            this.mob = mob;
            this.speedModifier = speedModifier;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && target.m_6084_() && !this.mob.isPreparingAttack();
        }

        @Override
        public boolean m_8045_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && target.m_6084_() && MultiAttackMob.this.attackWarmupDelay > 0;
        }

        @Override
        public void m_8056_() {
            MultiAttackMob.this.m_21561_(true);
            MultiAttackMob.this.setCurrentAttack(this.getAttack());
            MultiAttackMob.this.preparingTickCount = this.getPreparingTime();
            this.nextAttackTickCount = MultiAttackMob.this.f_19797_ + this.getAttackInterval();
            this.onPrepare();
            this.ticksUntilNextPathRecalc = 0;
            this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), this.speedModifier);
            this.storeTargetPosition();
        }

        @Override
        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (--this.ticksUntilNextPathRecalc <= 0 && (this.distanceToStoredTargetSqr(target) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.storeTargetPosition();
                this.ticksUntilNextPathRecalc += 5;
                this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
            }
            if (!this.mob.isPreparingAttack() && this.mob.attackWarmupDelay == 0 && this.mob.globalCooldown == 0 && this.mob.attackAnimationTick <= 5) {
                double distSq = this.mob.m_262793_(target);
                if (distSq > 1024.0) {
                    this.ticksUntilNextPathRecalc += 10;
                } else if (distSq > 256.0) {
                    this.ticksUntilNextPathRecalc += 5;
                }
                if (MultiAttackMob.this.m_217066_(target)) {
                    this.mob.attackAnimationTick = 0;
                    this.mob.attackWarmupDelay = this.m_183277_(this.getPreparingTime());
                    this.mob.globalCooldown = 20;
                    this.mob.m_5496_(this.getAttackSound(), 1.0f, 1.0f);
                    this.onPrepare();
                }
            }
        }

        private void storeTargetPosition() {
            LivingEntity target = this.mob.m_5448_();
            this.lastTargetX = target.m_20185_();
            this.lastTargetY = target.m_20186_();
            this.lastTargetZ = target.m_20189_();
        }

        private double distanceToStoredTargetSqr(LivingEntity target) {
            return target.m_20275_(this.lastTargetX, this.lastTargetY, this.lastTargetZ);
        }

        @Override
        protected void performAttack() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null && target.m_6084_()) {
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)target);
            }
        }

        public abstract int attackAnimationTick();

        public void beforeAttack() {
            MultiAttackMob.this.attackAnimationTick = this.attackAnimationTick();
            SoundEvent soundevent = this.getPrepareSound();
            if (soundevent != null) {
                MultiAttackMob.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
        }

        @Override
        public void onPrepare() {
            if (this.mob.m_5448_() != null && MultiAttackMob.this.m_217066_(this.mob.m_5448_())) {
                this.beforeAttack();
            }
        }
    }

    public class PrepareGoal
    extends Goal {
        public PrepareGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return MultiAttackMob.this.getPreparingTime() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            MultiAttackMob.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            MultiAttackMob.this.setCurrentAttack(AttackRegistry.NONE);
        }

        public void m_8037_() {
            if (MultiAttackMob.this.m_5448_() != null) {
                MultiAttackMob.this.m_21563_().m_24960_((Entity)MultiAttackMob.this.m_5448_(), (float)MultiAttackMob.this.m_8085_(), (float)MultiAttackMob.this.m_8132_());
            }
        }
    }
}

