/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.projectiles;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.util.Log;

public abstract class AbstractTridotArrow
extends AbstractArrow {
    public ItemStack arrowItem = ItemStack.f_41583_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();

    public AbstractTridotArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AbstractTridotArrow(EntityType<? extends AbstractArrow> pEntityType, Level worldIn, LivingEntity thrower, double baseDamage) {
        super(pEntityType, thrower, worldIn);
        this.f_36698_ = baseDamage;
    }

    public AbstractTridotArrow(EntityType<? extends AbstractArrow> pEntityType, Level worldIn, LivingEntity thrower, ItemStack thrownStackIn, double baseDamage) {
        super(pEntityType, thrower, worldIn);
        this.arrowItem = new ItemStack((ItemLike)thrownStackIn.m_41720_());
        this.f_36698_ = baseDamage;
    }

    public void doPostSpawn() {
    }

    public void m_8119_() {
        try {
            super.m_8119_();
        }
        catch (Throwable t) {
            String msg = String.format("AbstractTridotArrow crashed! Class=%s, UUID=%s", ((Object)((Object)this)).getClass().getName(), this.m_20148_());
            Log.getLogger().error(msg, t);
            this.m_146870_();
            return;
        }
        if (this.m_9236_().m_5776_() && !this.m_20072_() && !this.m_5830_()) {
            BlockPos below = this.m_20183_().m_7495_();
            BlockState state = this.m_9236_().m_8055_(below);
            if (!state.m_60713_(Blocks.f_50628_)) {
                this.spawnParticlesTrail();
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void addEffect(MobEffectInstance pEffectInstance) {
        this.effects.add(pEffectInstance);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)pCompound)) {
            this.addEffect(mobeffectinstance);
        }
    }

    protected void m_7761_(LivingEntity pLiving) {
        super.m_7761_(pLiving);
        Entity entity = this.m_150173_();
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effect : this.effects) {
                pLiving.m_147207_(effect, entity);
            }
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        super.m_5790_(pResult);
    }

    public void setEffectsFromList(ImmutableList<MobEffectInstance> effects) {
        for (MobEffectInstance mobeffectinstance : effects) {
            this.effects.add(new MobEffectInstance(mobeffectinstance));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
    }

    public ItemStack m_7941_() {
        return this.arrowItem;
    }
}

