/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.skins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.common.registry.item.skins.SkinEntry;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;
import pro.komaru.tridot.util.Col;

public class SkinBuilder {
    public String id;
    public List<SkinEntry> skinEntries = new ArrayList<SkinEntry>();
    public Col color;
    public List<MutableComponent> component;
    public Component hoverName;

    public SkinBuilder(String namespace, String id) {
        this.id = namespace + ":" + id;
    }

    public SkinBuilder(ResourceLocation loc) {
        this.id = loc.toString();
    }

    public SkinBuilder color(Col color) {
        this.color = color;
        return this;
    }

    public SkinBuilder add(SkinEntry entry) {
        this.skinEntries.add(entry);
        return this;
    }

    public SkinBuilder component(MutableComponent component) {
        this.component.add(component);
        return this;
    }

    public SkinBuilder component(MutableComponent ... components) {
        Collections.addAll(this.component, components);
        return this;
    }

    public SkinBuilder contributor(String name) {
        this.hoverName = Component.m_237113_((String)(" \u0f36" + name + "\u0f36"));
        return this;
    }

    public SkinBuilder contributor(String name, Style style) {
        this.hoverName = Component.m_237113_((String)(" \u0f36" + name + "\u0f36")).m_6270_(style);
        return this;
    }

    public ItemSkin build() {
        ItemSkin skin = new ItemSkin(this);
        SkinRegistryManager.add(skin);
        for (SkinEntry entry : this.skinEntries) {
            skin.entries.add(entry);
        }
        return skin;
    }
}

