/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.math;

import java.io.Serializable;
import java.util.HashMap;
import pro.komaru.tridot.util.math.Mathf;
import pro.komaru.tridot.util.struct.Structs;
import pro.komaru.tridot.util.struct.data.Seq;

public interface Interp
extends Serializable {
    public static final Interp catmullrom = a -> Mathf.catmullrom(Seq.with(Float.valueOf(0.0f), Float.valueOf(1.0f)), 0, 1, a);
    public static final Interp linear = a -> a;
    public static final Interp reverse = a -> 1.0f - a;
    public static final Interp smooth = a -> a * a * (3.0f - 2.0f * a);
    public static final Interp smooth2 = a -> {
        a = a * a * (3.0f - 2.0f * a);
        return a * a * (3.0f - 2.0f * a);
    };
    public static final Interp one = a -> 1.0f;
    public static final Interp zero = a -> 0.0f;
    public static final Interp slope = Mathf::slope;
    public static final Interp smoother;
    public static final Interp fade;
    public static final Pow pow2;
    public static final PowIn pow2In;
    public static final PowIn slowFast;
    public static final PowOut pow2Out;
    public static final PowOut fastSlow;
    public static final Interp pow2InInverse;
    public static final Interp pow2OutInverse;
    public static final Pow pow3;
    public static final PowIn pow3In;
    public static final PowOut pow3Out;
    public static final Interp pow3InInverse;
    public static final Interp pow3OutInverse;
    public static final Pow pow4;
    public static final PowIn pow4In;
    public static final PowOut pow4Out;
    public static final Pow pow5;
    public static final PowIn pow5In;
    public static final PowIn pow10In;
    public static final PowOut pow10Out;
    public static final PowOut pow5Out;
    public static final Interp sine;
    public static final Interp sineIn;
    public static final Interp sineOut;
    public static final Exp exp10;
    public static final ExpIn exp10In;
    public static final ExpOut exp10Out;
    public static final Exp exp5;
    public static final ExpIn exp5In;
    public static final ExpOut exp5Out;
    public static final Interp circle;
    public static final Interp circleIn;
    public static final Interp circleOut;
    public static final Elastic elastic;
    public static final ElasticIn elasticIn;
    public static final ElasticOut elasticOut;
    public static final Swing swing;
    public static final SwingIn swingIn;
    public static final SwingOut swingOut;
    public static final Bounce bounce;
    public static final BounceIn bounceIn;
    public static final BounceOut bounceOut;
    public static final HashMap<String, Interp> table;
    public static final HashMap<Interp, String> invTable;

    public float apply(float var1);

    default public float apply(float v, float min, float max) {
        return Mathf.lerp(min, max, this.apply(v));
    }

    static {
        fade = smoother = a -> a * a * a * (a * (a * 6.0f - 15.0f) + 10.0f);
        pow2 = new Pow(2);
        slowFast = pow2In = new PowIn(2);
        fastSlow = pow2Out = new PowOut(2);
        pow2InInverse = a -> (float)Math.sqrt(a);
        pow2OutInverse = a -> 1.0f - (float)Math.sqrt(-(a - 1.0f));
        pow3 = new Pow(3);
        pow3In = new PowIn(3);
        pow3Out = new PowOut(3);
        pow3InInverse = a -> (float)Math.cbrt(a);
        pow3OutInverse = a -> 1.0f - (float)Math.cbrt(-(a - 1.0f));
        pow4 = new Pow(4);
        pow4In = new PowIn(4);
        pow4Out = new PowOut(4);
        pow5 = new Pow(5);
        pow5In = new PowIn(5);
        pow10In = new PowIn(10);
        pow10Out = new PowOut(10);
        pow5Out = new PowOut(5);
        sine = a -> (1.0f - Mathf.cos(a * Mathf.PI)) / 2.0f;
        sineIn = a -> 1.0f - Mathf.cos(a * Mathf.PI / 2.0f);
        sineOut = a -> Mathf.sin(a * Mathf.PI / 2.0f);
        exp10 = new Exp(2.0f, 10.0f);
        exp10In = new ExpIn(2.0f, 10.0f);
        exp10Out = new ExpOut(2.0f, 10.0f);
        exp5 = new Exp(2.0f, 5.0f);
        exp5In = new ExpIn(2.0f, 5.0f);
        exp5Out = new ExpOut(2.0f, 5.0f);
        circle = a -> {
            if (a <= 0.5f) {
                return (1.0f - (float)Math.sqrt(1.0f - (a *= 2.0f) * a)) / 2.0f;
            }
            a -= 1.0f;
            return ((float)Math.sqrt(1.0f - (a *= 2.0f) * a) + 1.0f) / 2.0f;
        };
        circleIn = a -> 1.0f - (float)Math.sqrt(1.0f - a * a);
        circleOut = a -> (float)Math.sqrt(1.0f - (a -= 1.0f) * a);
        elastic = new Elastic(2.0f, 10.0f, 7, 1.0f);
        elasticIn = new ElasticIn(2.0f, 10.0f, 6, 1.0f);
        elasticOut = new ElasticOut(2.0f, 10.0f, 7, 1.0f);
        swing = new Swing(1.5f);
        swingIn = new SwingIn(2.0f);
        swingOut = new SwingOut(2.0f);
        bounce = new Bounce(4);
        bounceIn = new BounceIn(4);
        bounceOut = new BounceOut(4);
        table = Structs.map(String.class, Interp.class, "linear", linear, "catmullrom", catmullrom, "reverse", reverse, "smooth", smooth, "smooth2", smooth2, "one", one, "zero", zero, "slope", slope, "smoother", smoother, "fade", smoother, "pow2", pow2, "pow2In", pow2In, "slowFast", pow2In, "pow2Out", pow2Out, "fastSlow", pow2Out, "pow2InInverse", pow2InInverse, "pow2OutInverse", pow2OutInverse, "pow3", pow3, "pow3In", pow3In, "pow3Out", pow3Out, "sine", sine, "sineIn", sineIn, "sineOut", sineOut, "circle", circle, "circleIn", circleIn, "circleOut", circleOut, "elastic", elastic, "elasticIn", elasticIn, "elasticOut", elasticOut, "swing", swing, "swingIn", swingIn, "swingOut", swingOut, "bounce", bounce, "bounceIn", bounceIn, "bounceOut", bounceOut);
        invTable = Structs.revMap(table);
    }

    public static class Pow
    implements Interp {
        final float power;

        public Pow(float power) {
            this.power = power;
        }

        public Pow(int power) {
            this.power = power;
        }

        @Override
        public float apply(float a) {
            if (a <= 0.5f) {
                return (float)Math.pow(a * 2.0f, this.power) / 2.0f;
            }
            return (float)Math.pow((a - 1.0f) * 2.0f, this.power) / (float)(this.power % 2.0f == 0.0f ? -2 : 2) + 1.0f;
        }
    }

    public static class PowIn
    extends Pow {
        public PowIn(float power) {
            super(power);
        }

        public PowIn(int power) {
            super(power);
        }

        @Override
        public float apply(float a) {
            return (float)Math.pow(a, this.power);
        }
    }

    public static class PowOut
    extends Pow {
        public PowOut(int power) {
            super(power);
        }

        public PowOut(float power) {
            super(power);
        }

        @Override
        public float apply(float a) {
            return (float)Math.pow(a - 1.0f, this.power) * (float)(this.power % 2.0f == 0.0f ? -1 : 1) + 1.0f;
        }
    }

    public static class Exp
    implements Interp {
        final float value;
        final float power;
        final float min;
        final float scale;

        public Exp(float value, float power) {
            this.value = value;
            this.power = power;
            this.min = (float)Math.pow(value, -power);
            this.scale = 1.0f / (1.0f - this.min);
        }

        @Override
        public float apply(float a) {
            if (a <= 0.5f) {
                return ((float)Math.pow(this.value, this.power * (a * 2.0f - 1.0f)) - this.min) * this.scale / 2.0f;
            }
            return (2.0f - ((float)Math.pow(this.value, -this.power * (a * 2.0f - 1.0f)) - this.min) * this.scale) / 2.0f;
        }
    }

    public static class ExpIn
    extends Exp {
        public ExpIn(float value, float power) {
            super(value, power);
        }

        @Override
        public float apply(float a) {
            return ((float)Math.pow(this.value, this.power * (a - 1.0f)) - this.min) * this.scale;
        }
    }

    public static class ExpOut
    extends Exp {
        public ExpOut(float value, float power) {
            super(value, power);
        }

        @Override
        public float apply(float a) {
            return 1.0f - ((float)Math.pow(this.value, -this.power * a) - this.min) * this.scale;
        }
    }

    public static class Elastic
    implements Interp {
        final float value;
        final float power;
        final float scale;
        final float bounces;

        public Elastic(float value, float power, int bounces, float scale) {
            this.value = value;
            this.power = power;
            this.scale = scale;
            this.bounces = (float)bounces * Mathf.PI * (float)(bounces % 2 == 0 ? 1 : -1);
        }

        @Override
        public float apply(float a) {
            if (a <= 0.5f) {
                return (float)Math.pow(this.value, this.power * ((a *= 2.0f) - 1.0f)) * Mathf.sin(a * this.bounces) * this.scale / 2.0f;
            }
            a = 1.0f - a;
            return 1.0f - (float)Math.pow(this.value, this.power * ((a *= 2.0f) - 1.0f)) * Mathf.sin(a * this.bounces) * this.scale / 2.0f;
        }
    }

    public static class ElasticIn
    extends Elastic {
        public ElasticIn(float value, float power, int bounces, float scale) {
            super(value, power, bounces, scale);
        }

        @Override
        public float apply(float a) {
            if ((double)a >= 0.99) {
                return 1.0f;
            }
            return (float)Math.pow(this.value, this.power * (a - 1.0f)) * Mathf.sin(a * this.bounces) * this.scale;
        }
    }

    public static class ElasticOut
    extends Elastic {
        public ElasticOut(float value, float power, int bounces, float scale) {
            super(value, power, bounces, scale);
        }

        @Override
        public float apply(float a) {
            if (a == 0.0f) {
                return 0.0f;
            }
            a = 1.0f - a;
            return 1.0f - (float)Math.pow(this.value, this.power * (a - 1.0f)) * Mathf.sin(a * this.bounces) * this.scale;
        }
    }

    public static class Swing
    implements Interp {
        private final float scale;

        public Swing(float scale) {
            this.scale = scale * 2.0f;
        }

        @Override
        public float apply(float a) {
            if (a <= 0.5f) {
                return (a *= 2.0f) * a * ((this.scale + 1.0f) * a - this.scale) / 2.0f;
            }
            a -= 1.0f;
            return (a *= 2.0f) * a * ((this.scale + 1.0f) * a + this.scale) / 2.0f + 1.0f;
        }
    }

    public static class SwingIn
    implements Interp {
        private final float scale;

        public SwingIn(float scale) {
            this.scale = scale;
        }

        @Override
        public float apply(float a) {
            return a * a * ((this.scale + 1.0f) * a - this.scale);
        }
    }

    public static class SwingOut
    implements Interp {
        private final float scale;

        public SwingOut(float scale) {
            this.scale = scale;
        }

        @Override
        public float apply(float a) {
            return (a -= 1.0f) * a * ((this.scale + 1.0f) * a + this.scale) + 1.0f;
        }
    }

    public static class Bounce
    extends BounceOut {
        public Bounce(float[] widths, float[] heights) {
            super(widths, heights);
        }

        public Bounce(int bounces) {
            super(bounces);
        }

        private float out(float a) {
            float test = a + this.widths[0] / 2.0f;
            if (test < this.widths[0]) {
                return test / (this.widths[0] / 2.0f) - 1.0f;
            }
            return super.apply(a);
        }

        @Override
        public float apply(float a) {
            if (a <= 0.5f) {
                return (1.0f - this.out(1.0f - a * 2.0f)) / 2.0f;
            }
            return this.out(a * 2.0f - 1.0f) / 2.0f + 0.5f;
        }
    }

    public static class BounceIn
    extends BounceOut {
        public BounceIn(float[] widths, float[] heights) {
            super(widths, heights);
        }

        public BounceIn(int bounces) {
            super(bounces);
        }

        @Override
        public float apply(float a) {
            return 1.0f - super.apply(1.0f - a);
        }
    }

    public static class BounceOut
    implements Interp {
        final float[] widths;
        final float[] heights;

        public BounceOut(float[] widths, float[] heights) {
            if (widths.length != heights.length) {
                throw new IllegalArgumentException("Must be the same number of widths and heights.");
            }
            this.widths = widths;
            this.heights = heights;
        }

        public BounceOut(int bounces) {
            if (bounces < 2 || bounces > 5) {
                throw new IllegalArgumentException("bounces cannot be < 2 or > 5: " + bounces);
            }
            this.widths = new float[bounces];
            this.heights = new float[bounces];
            this.heights[0] = 1.0f;
            switch (bounces) {
                case 2: {
                    this.widths[0] = 0.6f;
                    this.widths[1] = 0.4f;
                    this.heights[1] = 0.33f;
                    break;
                }
                case 3: {
                    this.widths[0] = 0.4f;
                    this.widths[1] = 0.4f;
                    this.widths[2] = 0.2f;
                    this.heights[1] = 0.33f;
                    this.heights[2] = 0.1f;
                    break;
                }
                case 4: {
                    this.widths[0] = 0.34f;
                    this.widths[1] = 0.34f;
                    this.widths[2] = 0.2f;
                    this.widths[3] = 0.15f;
                    this.heights[1] = 0.26f;
                    this.heights[2] = 0.11f;
                    this.heights[3] = 0.03f;
                    break;
                }
                case 5: {
                    this.widths[0] = 0.3f;
                    this.widths[1] = 0.3f;
                    this.widths[2] = 0.2f;
                    this.widths[3] = 0.1f;
                    this.widths[4] = 0.1f;
                    this.heights[1] = 0.45f;
                    this.heights[2] = 0.3f;
                    this.heights[3] = 0.15f;
                    this.heights[4] = 0.06f;
                }
            }
            this.widths[0] = this.widths[0] * 2.0f;
        }

        @Override
        public float apply(float a) {
            if (a == 1.0f) {
                return 1.0f;
            }
            a += this.widths[0] / 2.0f;
            float width = 0.0f;
            float height = 0.0f;
            int n = this.widths.length;
            for (int i = 0; i < n; ++i) {
                width = this.widths[i];
                if (a <= width) {
                    height = this.heights[i];
                    break;
                }
                a -= width;
            }
            float z = 4.0f / width * height * (a /= width);
            return 1.0f - (z - z * a) * width;
        }
    }
}

