/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.struct;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import pro.komaru.tridot.util.Log;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.func.Cons;
import pro.komaru.tridot.util.struct.func.Func;
import pro.komaru.tridot.util.struct.func.Prov;

public class Structs {
    public static <A> Prov<A> nil() {
        return () -> null;
    }

    public static Object cast(Object obj, String type) {
        try {
            return switch (type.toLowerCase()) {
                case "string", "str" -> obj.toString();
                case "integer", "int", "i" -> {
                    if (obj instanceof Number) {
                        yield ((Number)obj).intValue();
                    }
                    if (obj instanceof String) {
                        yield Integer.parseInt((String)obj);
                    }
                    yield null;
                }
                case "double", "d" -> {
                    if (obj instanceof Number) {
                        yield ((Number)obj).doubleValue();
                    }
                    if (obj instanceof String) {
                        yield Double.parseDouble((String)obj);
                    }
                    yield null;
                }
                case "boolean", "b" -> {
                    if (obj instanceof Boolean) {
                        yield obj;
                    }
                    if (obj instanceof String) {
                        yield Boolean.parseBoolean((String)obj);
                    }
                    yield null;
                }
                default -> {
                    System.err.println("Unsupported type: " + type);
                    yield null;
                }
            };
        }
        catch (ClassCastException | NumberFormatException e) {
            Log.error(e.toString(), new Object[0]);
            return null;
        }
    }

    public static <A, B> A cast(B obj) {
        return (A)obj;
    }

    public static <T> T or(T a, T b) {
        if (a == null) {
            return b;
        }
        return a;
    }

    public static String or(String a, String b) {
        if (a == null) {
            return b;
        }
        if (a.isBlank()) {
            return b;
        }
        return a;
    }

    public static <T, A> A safeGet(T a, Func<T, A> cb) {
        return Structs.safeGet(a, cb, Structs.nil());
    }

    public static <T, A> A safeGet(T a, Func<T, A> cb, Prov<A> def) {
        if (a != null) {
            return cb.get(a);
        }
        return def.get();
    }

    public static <T> void safeRun(T obj, Cons<T> cb) {
        if (obj != null) {
            cb.get(obj);
        }
    }

    public static <T> void safeRun(T obj, Runnable cb) {
        if (obj != null) {
            cb.run();
        }
    }

    public static <K, V> HashMap<K, V> map(Class<K> key, Class<V> val, Object ... objs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < objs.length; i += 2) {
            Object k = objs[i];
            Object v = objs[i + 1];
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> HashMap<K, V> map(Object ... objs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < objs.length; i += 2) {
            Object k = objs[i];
            Object v = objs[i + 1];
            map.put(k, v);
        }
        return map;
    }

    public static <A> A[] pop(A[] def) {
        Seq<A> n = Seq.with(def);
        n.slice();
        return n.toArray();
    }

    public static <K, V> HashMap<V, K> revMap(HashMap<K, V> mapOrig) {
        HashMap map = new HashMap();
        mapOrig.forEach((k, v) -> map.put(v, k));
        return map;
    }

    public static byte[] obj(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        if (!(obj instanceof Serializable)) {
            throw new IllegalArgumentException("Object is not Serializable");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static <K> K obj(Class<K> cast, byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Bytes can't be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (K)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

